/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopJob
extends Configured
implements Tool {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHadoopJob.class);
    protected static final Option OPTION_JOB_NAME;
    protected static final Option OPTION_CUBE_NAME;
    protected static final Option OPTION_CUBING_JOB_ID;
    protected static final Option OPTION_SEGMENT_NAME;
    protected static final Option OPTION_SEGMENT_ID;
    protected static final Option OPTION_INPUT_PATH;
    protected static final Option OPTION_INPUT_FORMAT;
    protected static final Option OPTION_OUTPUT_PATH;
    protected static final Option OPTION_NCUBOID_LEVEL;
    protected static final Option OPTION_PARTITION_FILE_PATH;
    protected static final Option OPTION_HTABLE_NAME;
    protected static final Option OPTION_STATISTICS_ENABLED;
    protected static final Option OPTION_STATISTICS_OUTPUT;
    protected static final Option OPTION_STATISTICS_SAMPLING_PERCENT;
    private static final String MAP_REDUCE_CLASSPATH = "mapreduce.application.classpath";
    protected String name;
    protected boolean isAsync = false;
    protected OptionsHelper optionsHelper = new OptionsHelper();
    protected Job job;

    protected static void runJob(Tool job, String[] args) {
        try {
            int exitCode = ToolRunner.run((Tool)job, (String[])args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(5);
        }
    }

    public AbstractHadoopJob() {
        super(HadoopUtil.getCurrentConfiguration());
    }

    protected void parseOptions(Options options, String[] args) throws ParseException {
        this.optionsHelper.parseOptions(options, args);
    }

    public void printUsage(Options options) {
        this.optionsHelper.printUsage(((Object)((Object)this)).getClass().getSimpleName(), options);
    }

    public Option[] getOptions() {
        return this.optionsHelper.getOptions();
    }

    public String getOptionsAsString() {
        return this.optionsHelper.getOptionsAsString();
    }

    protected String getOptionValue(Option option) {
        return this.optionsHelper.getOptionValue(option);
    }

    protected boolean hasOption(Option option) {
        return this.optionsHelper.hasOption(option);
    }

    protected int waitForCompletion(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        int retVal = 0;
        long start = System.nanoTime();
        if (this.isAsync) {
            job.submit();
        } else {
            job.waitForCompletion(true);
            retVal = job.isSuccessful() ? 0 : 1;
            logger.debug("Job '" + job.getJobName() + "' finished " + (job.isSuccessful() ? "successfully in " : "with failures.  Time taken ") + org.apache.hadoop.util.StringUtils.formatTime((long)((System.nanoTime() - start) / 1000000L)));
        }
        return retVal;
    }

    protected void setJobClasspath(Job job, KylinConfig kylinConf) {
        String jarPath = kylinConf.getKylinJobJarPath();
        File jarFile = new File(jarPath);
        if (jarFile.exists()) {
            job.setJar(jarPath);
            logger.info("append job jar: " + jarPath);
        } else {
            job.setJarByClass(((Object)((Object)this)).getClass());
        }
        String kylinHiveDependency = System.getProperty("kylin.hive.dependency");
        String kylinHBaseDependency = System.getProperty("kylin.hbase.dependency");
        String kylinKafkaDependency = System.getProperty("kylin.kafka.dependency");
        logger.info("append kylin.hbase.dependency: " + kylinHBaseDependency + " to " + MAP_REDUCE_CLASSPATH);
        Configuration jobConf = job.getConfiguration();
        String classpath = jobConf.get(MAP_REDUCE_CLASSPATH);
        if (classpath == null || classpath.length() == 0) {
            logger.info("Didn't find mapreduce.application.classpath in job configuration, will run 'mapred classpath' to get the default value.");
            classpath = this.getDefaultMapRedClasspath();
            logger.info("The default mapred classpath is: " + classpath);
        }
        if (kylinHBaseDependency != null) {
            kylinHBaseDependency = kylinHBaseDependency.replace(":", ",");
            classpath = classpath + "," + kylinHBaseDependency;
        }
        jobConf.set(MAP_REDUCE_CLASSPATH, classpath);
        logger.info("Hadoop job classpath is: " + job.getConfiguration().get(MAP_REDUCE_CLASSPATH));
        StringBuilder kylinDependency = new StringBuilder();
        if (kylinHiveDependency != null) {
            kylinHiveDependency = kylinHiveDependency.replace(":", ",");
            logger.info("Hive Dependencies Before Filtered: " + kylinHiveDependency);
            String filteredHive = this.filterKylinHiveDependency(kylinHiveDependency, kylinConf);
            logger.info("Hive Dependencies After Filtered: " + filteredHive);
            StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)filteredHive);
        } else {
            logger.info("No hive dependency jars set in the environment, will find them from classpath:");
            try {
                String hiveExecJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.ql.Driver"));
                StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)hiveExecJarPath);
                logger.info("hive-exec jar file: " + hiveExecJarPath);
                String hiveHCatJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hive.hcatalog.mapreduce.HCatInputFormat"));
                StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)hiveHCatJarPath);
                logger.info("hive-catalog jar file: " + hiveHCatJarPath);
                String hiveMetaStoreJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.metastore.api.Table"));
                StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)hiveMetaStoreJarPath);
                logger.info("hive-metastore jar file: " + hiveMetaStoreJarPath);
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot found hive dependency jars: " + e);
            }
        }
        if (kylinKafkaDependency != null) {
            kylinKafkaDependency = kylinKafkaDependency.replace(":", ",");
            logger.info("Kafka Dependencies: " + kylinKafkaDependency);
            StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)kylinKafkaDependency);
        } else {
            logger.info("No Kafka dependency jar set in the environment, will find them from classpath:");
            try {
                String kafkaClientJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.kafka.clients.consumer.KafkaConsumer"));
                StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)kafkaClientJarPath);
                logger.info("kafka jar file: " + kafkaClientJarPath);
            }
            catch (ClassNotFoundException e) {
                logger.debug("Not found kafka client jar from classpath, it is optional for normal build: " + e);
            }
        }
        String mrLibDir = kylinConf.getKylinJobMRLibDir();
        StringUtil.appendWithSeparator((StringBuilder)kylinDependency, (String)mrLibDir);
        this.setJobTmpJarsAndFiles(job, kylinDependency.toString());
        this.overrideJobConfig(job.getConfiguration(), kylinConf.getMRConfigOverride());
    }

    private void overrideJobConfig(Configuration jobConf, Map<String, String> override) {
        for (Map.Entry<String, String> entry : override.entrySet()) {
            jobConf.set(entry.getKey(), entry.getValue());
        }
    }

    private String filterKylinHiveDependency(String kylinHiveDependency, KylinConfig config) {
        if (StringUtils.isBlank((String)kylinHiveDependency)) {
            return "";
        }
        StringBuilder jarList = new StringBuilder();
        Pattern hivePattern = Pattern.compile(config.getHiveDependencyFilterList());
        Matcher matcher = hivePattern.matcher(kylinHiveDependency);
        while (matcher.find()) {
            if (jarList.length() > 0) {
                jarList.append(",");
            }
            jarList.append(matcher.group());
        }
        return jarList.toString();
    }

    private void setJobTmpJarsAndFiles(Job job, String kylinDependency) {
        if (StringUtils.isBlank((String)kylinDependency)) {
            return;
        }
        String[] fNameList = kylinDependency.split(",");
        try {
            Configuration jobConf = job.getConfiguration();
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)jobConf);
            FileSystem hdfs = HadoopUtil.getWorkingFileSystem((Configuration)jobConf);
            StringBuilder jarList = new StringBuilder();
            StringBuilder fileList = new StringBuilder();
            for (String fileName : fNameList) {
                StringBuilder list;
                FileSystem fs;
                Path p = new Path(fileName);
                if (!p.isAbsolute()) {
                    logger.warn("The directory of kylin dependency '" + fileName + "' is not absolute, skip");
                    continue;
                }
                if (AbstractHadoopJob.exists(hdfs, p)) {
                    fs = hdfs;
                } else if (AbstractHadoopJob.exists((FileSystem)localfs, p)) {
                    fs = localfs;
                } else {
                    logger.warn("The directory of kylin dependency '" + fileName + "' does not exist, skip");
                    continue;
                }
                if (fs.getFileStatus(p).isDirectory()) {
                    this.appendTmpDir(job, fs, p, jarList, fileList);
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath());
            }
            this.appendTmpFiles(fileList.toString(), jobConf);
            this.appendTmpJars(jarList.toString(), jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpDir(Job job, FileSystem fs, Path tmpDir, StringBuilder jarList, StringBuilder fileList) {
        try {
            FileStatus[] fList;
            for (FileStatus file : fList = fs.listStatus(tmpDir)) {
                StringBuilder list;
                Path p = file.getPath();
                if (fs.getFileStatus(p).isDirectory()) {
                    this.appendTmpDir(job, fs, p, jarList, fileList);
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath().toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpJars(String jarList, Configuration conf) {
        if (StringUtils.isBlank((String)jarList)) {
            return;
        }
        String tmpJars = conf.get("tmpjars", null);
        tmpJars = tmpJars == null ? jarList : tmpJars + "," + jarList;
        conf.set("tmpjars", tmpJars);
        logger.info("Job 'tmpjars' updated -- " + tmpJars);
    }

    private void appendTmpFiles(String fileList, Configuration conf) {
        if (StringUtils.isBlank((String)fileList)) {
            return;
        }
        String tmpFiles = conf.get("tmpfiles", null);
        tmpFiles = tmpFiles == null ? fileList : tmpFiles + "," + fileList;
        conf.set("tmpfiles", tmpFiles);
        logger.info("Job 'tmpfiles' updated -- " + tmpFiles);
    }

    private String getDefaultMapRedClasspath() {
        String classpath = "";
        try {
            CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
            String output = (String)executor.execute("mapred classpath").getSecond();
            classpath = output.trim().replace(':', ',');
        }
        catch (IOException e) {
            logger.error("Failed to run: 'mapred classpath'.", (Throwable)e);
        }
        return classpath;
    }

    private static boolean exists(FileSystem fs, Path p) throws IOException {
        try {
            return fs.exists(p);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static int addInputDirs(String input, Job job) throws IOException {
        int folderNum = AbstractHadoopJob.addInputDirs(StringSplitter.split((String)input, (String)","), job);
        logger.info("Number of added folders:" + folderNum);
        return folderNum;
    }

    public static int addInputDirs(String[] inputs, Job job) throws IOException {
        int ret = 0;
        for (String inp : inputs) {
            if ((inp = inp.trim()).endsWith("/*")) {
                Path path;
                inp = inp.substring(0, inp.length() - 2);
                FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)job.getConfiguration());
                if (!AbstractHadoopJob.exists(fs, path = new Path(inp))) {
                    logger.warn("Path not exist:" + path.toString());
                    continue;
                }
                FileStatus[] fileStatuses = fs.listStatus(path);
                boolean hasDir = false;
                for (FileStatus stat : fileStatuses) {
                    if (!stat.isDirectory() || stat.getPath().getName().startsWith("_")) continue;
                    hasDir = true;
                    ret += AbstractHadoopJob.addInputDirs(new String[]{stat.getPath().toString()}, job);
                }
                if (fileStatuses.length <= 0 || hasDir) continue;
                ret += AbstractHadoopJob.addInputDirs(new String[]{path.toString()}, job);
                continue;
            }
            logger.debug("Add input " + inp);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inp));
            ++ret;
        }
        return ret;
    }

    public static KylinConfig loadKylinPropsAndMetadata() throws IOException {
        File metaDir = new File("meta");
        if (!metaDir.getAbsolutePath().equals(System.getProperty("KYLIN_CONF"))) {
            System.setProperty("KYLIN_CONF", metaDir.getAbsolutePath());
            logger.info("The absolute path for meta dir is " + metaDir.getAbsolutePath());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            kylinConfig.setMetadataUrl(metaDir.getAbsolutePath());
            return kylinConfig;
        }
        return KylinConfig.getInstanceFromEnv();
    }

    protected void attachTableMetadata(TableDesc table, Configuration conf) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.add(table.getResourcePath());
        this.dumpKylinPropsAndMetadata(dumpList, KylinConfig.getInstanceFromEnv(), conf);
    }

    protected void attachCubeMetadata(CubeInstance cube, Configuration conf) throws IOException {
        this.dumpKylinPropsAndMetadata(this.collectCubeMetadata(cube), cube.getConfig(), conf);
    }

    protected void attachCubeMetadataWithDict(CubeInstance cube, Configuration conf) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(this.collectCubeMetadata(cube));
        for (CubeSegment segment : cube.getSegments()) {
            dumpList.addAll(segment.getDictionaryPaths());
        }
        this.dumpKylinPropsAndMetadata(dumpList, cube.getConfig(), conf);
    }

    protected void attachSegmentMetadataWithDict(CubeSegment segment, Configuration conf) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(this.collectCubeMetadata(segment.getCubeInstance()));
        dumpList.addAll(segment.getDictionaryPaths());
        this.dumpKylinPropsAndMetadata(dumpList, segment.getConfig(), conf);
    }

    private Set<String> collectCubeMetadata(CubeInstance cube) {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.add(cube.getResourcePath());
        dumpList.add(cube.getDescriptor().getModel().getResourcePath());
        dumpList.add(cube.getDescriptor().getResourcePath());
        for (TableRef tableRef : cube.getDescriptor().getModel().getAllTables()) {
            TableDesc table = tableRef.getTableDesc();
            dumpList.add(table.getResourcePath());
            dumpList.addAll(SourceFactory.getMRDependentResources((TableDesc)table));
        }
        return dumpList;
    }

    protected void dumpKylinPropsAndMetadata(Set<String> dumpList, KylinConfig kylinConfig, Configuration conf) throws IOException {
        File tmp = File.createTempFile("kylin_job_meta", "");
        FileUtils.forceDelete((File)tmp);
        File metaDir = new File(tmp, "meta");
        metaDir.mkdirs();
        File kylinPropsFile = new File(metaDir, "kylin.properties");
        kylinConfig.writeProperties(kylinPropsFile);
        this.dumpResources(kylinConfig, metaDir, dumpList);
        String hdfsMetaDir = OptionsHelper.convertToFileURL((String)metaDir.getAbsolutePath());
        hdfsMetaDir = hdfsMetaDir.startsWith("/") ? "file://" + hdfsMetaDir : "file:///" + hdfsMetaDir;
        logger.info("HDFS meta dir is: " + hdfsMetaDir);
        this.appendTmpFiles(hdfsMetaDir, conf);
    }

    protected void cleanupTempConfFile(Configuration conf) {
        String tempMetaFileString = conf.get("tmpfiles");
        logger.info("tempMetaFileString is : " + tempMetaFileString);
        if (tempMetaFileString != null) {
            if (tempMetaFileString.startsWith("file://")) {
                File tempMetaFile = new File(tempMetaFileString = tempMetaFileString.substring("file://".length()));
                if (tempMetaFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)tempMetaFile.getParentFile());
                    }
                    catch (IOException e) {
                        logger.warn("error when deleting " + tempMetaFile, (Throwable)e);
                    }
                } else {
                    logger.info("" + tempMetaFileString + " does not exist");
                }
            } else {
                logger.info("tempMetaFileString is not starting with file:// :" + tempMetaFileString);
            }
        }
    }

    private void dumpResources(KylinConfig kylinConfig, File metaDir, Set<String> dumpList) throws IOException {
        long startTime = System.currentTimeMillis();
        ResourceStore from = ResourceStore.getStore((KylinConfig)kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri((String)metaDir.getAbsolutePath());
        ResourceStore to = ResourceStore.getStore((KylinConfig)localConfig);
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.inputStream, res.timestamp);
            res.inputStream.close();
        }
        logger.debug("Dump resources to {} took {} ms", (Object)metaDir, (Object)(System.currentTimeMillis() - startTime));
    }

    protected void deletePath(Configuration conf, Path path) throws IOException {
        HadoopUtil.deletePath((Configuration)conf, (Path)path);
    }

    protected double getTotalMapInputMB() throws ClassNotFoundException, IOException, InterruptedException, JobException {
        if (this.job == null) {
            throw new JobException("Job is null");
        }
        long mapInputBytes = 0L;
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)this.job.getConfiguration());
        for (InputSplit split : input.getSplits((JobContext)this.job)) {
            mapInputBytes += split.getLength();
        }
        if (mapInputBytes == 0L) {
            throw new IllegalArgumentException("Map input splits are 0 bytes, something is wrong!");
        }
        double totalMapInputMB = (double)mapInputBytes / 1024.0 / 1024.0;
        return totalMapInputMB;
    }

    protected int getMapInputSplitCount() throws ClassNotFoundException, JobException, IOException, InterruptedException {
        if (this.job == null) {
            throw new JobException("Job is null");
        }
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)this.job.getConfiguration());
        return input.getSplits((JobContext)this.job).size();
    }

    public void kill() throws JobException {
        if (this.job != null) {
            try {
                this.job.killJob();
            }
            catch (IOException e) {
                throw new JobException((Throwable)e);
            }
        }
    }

    public Map<String, String> getInfo() throws JobException {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        throw new JobException("Job is null");
    }

    public Counters getCounters() throws JobException {
        if (this.job != null) {
            try {
                return this.job.getCounters();
            }
            catch (IOException e) {
                throw new JobException((Throwable)e);
            }
        }
        throw new JobException("Job is null");
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean isSkipped() {
        return false;
    }

    static {
        OptionBuilder.withArgName((String)"jobname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Job name. For example, Kylin_Cuboid_Builder-clsfd_v2_Step_22-D)");
        OPTION_JOB_NAME = OptionBuilder.create((String)"jobname");
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube name. For exmaple, flat_item_cube");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"cubingJobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"ID of cubing job executable");
        OPTION_CUBING_JOB_ID = OptionBuilder.create((String)"cubingJobId");
        OptionBuilder.withArgName((String)"segmentname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube segment name");
        OPTION_SEGMENT_NAME = OptionBuilder.create((String)"segmentname");
        OptionBuilder.withArgName((String)"segmentid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube segment id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentid");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Input path");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"inputformat");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Input format");
        OPTION_INPUT_FORMAT = OptionBuilder.create((String)"inputformat");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"N-Cuboid build level, e.g. 1, 2, 3...");
        OPTION_NCUBOID_LEVEL = OptionBuilder.create((String)"level");
        OptionBuilder.withArgName((String)"partitions");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Partition file path.");
        OPTION_PARTITION_FILE_PATH = OptionBuilder.create((String)"partitions");
        OptionBuilder.withArgName((String)"htablename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HTable name");
        OPTION_HTABLE_NAME = OptionBuilder.create((String)"htablename");
        OptionBuilder.withArgName((String)"statisticsenabled");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics enabled");
        OPTION_STATISTICS_ENABLED = OptionBuilder.create((String)"statisticsenabled");
        OptionBuilder.withArgName((String)"statisticsoutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics output");
        OPTION_STATISTICS_OUTPUT = OptionBuilder.create((String)"statisticsoutput");
        OptionBuilder.withArgName((String)"statisticssamplingpercent");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics sampling percentage");
        OPTION_STATISTICS_SAMPLING_PERCENT = OptionBuilder.create((String)"statisticssamplingpercent");
    }
}

