/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.kylin.source.ReadableTable;

public class SortedColumnDFSFileReader
implements ReadableTable.TableReader {
    private Collection<ReadableTable.TableReader> readers;
    private Comparator<String> comparator;
    private PriorityQueue<ReaderBuffer> pq;
    private String[] row;

    public SortedColumnDFSFileReader(Collection<ReadableTable.TableReader> readers, final Comparator<String> comparator) {
        this.readers = readers;
        this.comparator = comparator;
        this.pq = new PriorityQueue<ReaderBuffer>(11, new Comparator<ReaderBuffer>(){

            @Override
            public int compare(ReaderBuffer i, ReaderBuffer j) {
                boolean isEmpty1 = i.empty();
                boolean isEmpty2 = j.empty();
                if (isEmpty1 && isEmpty2) {
                    return 0;
                }
                if (isEmpty1 && !isEmpty2) {
                    return 1;
                }
                if (!isEmpty1 && isEmpty2) {
                    return -1;
                }
                return comparator.compare(i.peek()[0], j.peek()[0]);
            }
        });
        for (ReadableTable.TableReader reader : readers) {
            if (reader == null) continue;
            try {
                this.pq.add(new ReaderBuffer(reader));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean next() throws IOException {
        if (this.pq.size() > 0) {
            ReaderBuffer buffer = this.pq.poll();
            String[] minEntry = buffer.pop();
            this.row = minEntry;
            if (buffer.empty()) {
                this.pq.remove(buffer);
            } else {
                this.pq.add(buffer);
            }
            return this.row != null;
        }
        return false;
    }

    public String[] getRow() {
        return this.row;
    }

    public void close() throws IOException {
        for (ReadableTable.TableReader reader : this.readers) {
            reader.close();
        }
    }

    static class ReaderBuffer {
        private ReadableTable.TableReader reader;
        private String[] row;

        public ReaderBuffer(ReadableTable.TableReader reader) throws IOException {
            this.reader = reader;
            this.reload();
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        public boolean empty() {
            return this.row == null;
        }

        public String[] peek() {
            return this.row;
        }

        public String[] pop() throws IOException {
            String[] result = this.row;
            this.reload();
            return result;
        }

        private void reload() throws IOException {
            this.row = this.reader.next() ? this.reader.getRow() : null;
        }
    }
}

