/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubingJob
extends DefaultChainedExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CubingJob.class);
    public static final String SOURCE_RECORD_COUNT = "sourceRecordCount";
    public static final String SOURCE_SIZE_BYTES = "sourceSizeBytes";
    public static final String CUBE_SIZE_BYTES = "byteSizeBytes";
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final String DEPLOY_ENV_NAME = "envName";
    private static final String PROJECT_INSTANCE_NAME = "projectName";

    public static CubingJob createBuildJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, "BUILD", submitter, config);
    }

    public static CubingJob createMergeJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, "MERGE", submitter, config);
    }

    private static CubingJob initCubingJob(CubeSegment seg, String jobType, String submitter, JobEngineConfig config) {
        KylinConfig kylinConfig = config.getConfig();
        CubeInstance cube = seg.getCubeInstance();
        List projList = ProjectManager.getInstance((KylinConfig)kylinConfig).findProjects(cube.getType(), cube.getName());
        if (projList == null || projList.size() == 0) {
            throw new RuntimeException("Cannot find the project containing the cube " + cube.getName() + "!!!");
        }
        if (projList.size() >= 2) {
            String msg = "Find more than one project containing the cube " + cube.getName() + ". It does't meet the uniqueness requirement!!! ";
            if (!config.getConfig().allowCubeAppearInMultipleProjects()) {
                throw new RuntimeException(msg);
            }
            logger.warn(msg);
        }
        CubingJob result = new CubingJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone(config.getTimeZone()));
        result.setDeployEnvName(kylinConfig.getDeployEnv());
        result.setProjectName(((ProjectInstance)projList.get(0)).getName());
        CubingExecutableUtil.setCubeName(seg.getCubeInstance().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        result.setName(seg.getCubeInstance().getName() + " - " + seg.getName() + " - " + jobType + " - " + format.format(new Date(System.currentTimeMillis())));
        result.setSubmitter(submitter);
        result.setNotifyList(seg.getCubeInstance().getDescriptor().getNotifyList());
        return result;
    }

    protected void setDeployEnvName(String name) {
        this.setParam(DEPLOY_ENV_NAME, name);
    }

    public String getDeployEnvName() {
        return this.getParam(DEPLOY_ENV_NAME);
    }

    protected void setProjectName(String name) {
        this.setParam(PROJECT_INSTANCE_NAME, name);
    }

    public String getProjectName() {
        return this.getParam(PROJECT_INSTANCE_NAME);
    }

    protected Pair<String, String> formatNotifications(ExecutableContext context, ExecutableState state) {
        String logMsg;
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)context.getConfig()).getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        Output output = this.getManager().getOutput(this.getId());
        state = output.getState();
        if (state != ExecutableState.ERROR && !cubeInstance.getDescriptor().getStatusNeedNotify().contains(state.toString())) {
            logger.info("state:" + state + " no need to notify users");
            return null;
        }
        switch (state) {
            case ERROR: {
                logMsg = output.getVerboseMsg();
                break;
            }
            case DISCARDED: {
                logMsg = "job has been discarded";
                break;
            }
            case SUCCEED: {
                logMsg = "job has succeeded";
                break;
            }
            default: {
                return null;
            }
        }
        String content = "<div><b>Build Result of Job ${job_name}</b><pre><ul><li>Build Result: <b>${result}</b></li><li>Job Engine: ${job_engine}</li><li>Env: ${env_name}</li><li>Project: ${project_name}</li><li>Cube Name: ${cube_name}</li><li>Source Records Count: ${source_records_count}</li><li>Start Time: ${start_time}</li><li>Duration: ${duration}</li><li>MR Waiting: ${mr_waiting}</li><li>Last Update Time: ${last_update_time}</li><li>Submitter: ${submitter}</li><li>Error Log: ${error_log}</li></ul></pre><div/>";
        content = content.replaceAll("\\$\\{job_name\\}", this.getName());
        content = content.replaceAll("\\$\\{result\\}", state.toString());
        content = content.replaceAll("\\$\\{env_name\\}", this.getDeployEnvName());
        content = content.replaceAll("\\$\\{project_name\\}", this.getProjectName());
        content = content.replaceAll("\\$\\{cube_name\\}", CubingExecutableUtil.getCubeName(this.getParams()));
        content = content.replaceAll("\\$\\{source_records_count\\}", String.valueOf(this.findSourceRecordCount()));
        content = content.replaceAll("\\$\\{start_time\\}", new Date(this.getStartTime()).toString());
        content = content.replaceAll("\\$\\{duration\\}", this.getDuration() / 60000L + "mins");
        content = content.replaceAll("\\$\\{mr_waiting\\}", this.getMapReduceWaitTime() / 60000L + "mins");
        content = content.replaceAll("\\$\\{last_update_time\\}", new Date(this.getLastModified()).toString());
        content = content.replaceAll("\\$\\{submitter\\}", StringUtil.noBlank((String)this.getSubmitter(), (String)"missing submitter"));
        content = content.replaceAll("\\$\\{error_log\\}", Matcher.quoteReplacement(StringUtil.noBlank((String)logMsg, (String)"no error message")));
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            content = content.replaceAll("\\$\\{job_engine\\}", inetAddress.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        String title = "[" + state.toString() + "] - [" + this.getDeployEnvName() + "] - [" + this.getProjectName() + "] - " + CubingExecutableUtil.getCubeName(this.getParams());
        return Pair.of((Object)title, (Object)content);
    }

    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        AbstractExecutable task;
        ExecutableState status;
        long time = 0L;
        Iterator i$ = this.getTasks().iterator();
        while (i$.hasNext() && (status = (task = (AbstractExecutable)i$.next()).getStatus()) == ExecutableState.SUCCEED) {
            if (!(task instanceof MapReduceExecutable)) continue;
            time += ((MapReduceExecutable)task).getMapReduceWaitTime();
        }
        this.setMapReduceWaitTime(time);
        super.onExecuteFinished(result, executableContext);
    }

    protected void handleMetaDataPersistException(Exception exception) {
        String title = "[ERROR] - [" + this.getDeployEnvName() + "] - [" + this.getProjectName() + "] - " + CubingExecutableUtil.getCubeName(this.getParams());
        String content = "<div><b>Build Result of Job ${job_name}</b><pre><ul><li>Build Result: <b>${result}</b></li><li>Job Engine: ${job_engine}</li><li>Env: ${env_name}</li><li>Project: ${project_name}</li><li>Cube Name: ${cube_name}</li><li>Source Records Count: ${source_records_count}</li><li>Start Time: ${start_time}</li><li>Duration: ${duration}</li><li>MR Waiting: ${mr_waiting}</li><li>Last Update Time: ${last_update_time}</li><li>Submitter: ${submitter}</li><li>Error Log: ${error_log}</li></ul></pre><div/>";
        String UNKNOWN = "UNKNOWN";
        String errMsg = null;
        if (exception != null) {
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            errMsg = out.toString();
        }
        content = content.replaceAll("\\$\\{job_name\\}", this.getName());
        content = content.replaceAll("\\$\\{result\\}", ExecutableState.ERROR.toString());
        content = content.replaceAll("\\$\\{env_name\\}", this.getDeployEnvName());
        content = content.replaceAll("\\$\\{project_name\\}", this.getProjectName());
        content = content.replaceAll("\\$\\{cube_name\\}", CubingExecutableUtil.getCubeName(this.getParams()));
        content = content.replaceAll("\\$\\{source_records_count\\}", "UNKNOWN");
        content = content.replaceAll("\\$\\{start_time\\}", "UNKNOWN");
        content = content.replaceAll("\\$\\{duration\\}", "UNKNOWN");
        content = content.replaceAll("\\$\\{mr_waiting\\}", "UNKNOWN");
        content = content.replaceAll("\\$\\{last_update_time\\}", "UNKNOWN");
        content = content.replaceAll("\\$\\{submitter\\}", StringUtil.noBlank((String)this.getSubmitter(), (String)"missing submitter"));
        content = content.replaceAll("\\$\\{error_log\\}", Matcher.quoteReplacement(StringUtil.noBlank((String)errMsg, (String)"no error message")));
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            content = content.replaceAll("\\$\\{job_engine\\}", inetAddress.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        this.sendMail(Pair.of((Object)title, (Object)content));
    }

    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong(MAP_REDUCE_WAIT_TIME, 0L);
    }

    public void setMapReduceWaitTime(long t) {
        this.addExtraInfo(MAP_REDUCE_WAIT_TIME, t + "");
    }

    public void setAlgorithm(AlgorithmEnum alg) {
        this.addExtraInfo("algorithm", alg.name());
    }

    public AlgorithmEnum getAlgorithm() {
        String alg = (String)this.getExtraInfo().get("algorithm");
        return alg == null ? null : AlgorithmEnum.valueOf(alg);
    }

    public boolean isLayerCubing() {
        return AlgorithmEnum.LAYER == this.getAlgorithm();
    }

    public boolean isInMemCubing() {
        return AlgorithmEnum.INMEM == this.getAlgorithm();
    }

    public long findSourceRecordCount() {
        return Long.parseLong(this.findExtraInfo(SOURCE_RECORD_COUNT, "0"));
    }

    public long findSourceSizeBytes() {
        return Long.parseLong(this.findExtraInfo(SOURCE_SIZE_BYTES, "0"));
    }

    public long findCubeSizeBytes() {
        return Long.parseLong(this.findExtraInfoBackward(CUBE_SIZE_BYTES, "0"));
    }

    public String findExtraInfo(String key, String dft) {
        return this.findExtraInfo(key, dft, false);
    }

    public String findExtraInfoBackward(String key, String dft) {
        return this.findExtraInfo(key, dft, true);
    }

    private String findExtraInfo(String key, String dft, boolean backward) {
        ArrayList tasks = new ArrayList(this.getTasks());
        if (backward) {
            Collections.reverse(tasks);
        }
        for (AbstractExecutable child : tasks) {
            Output output = this.getManager().getOutput(child.getId());
            String value = (String)output.getExtra().get(key);
            if (value == null) continue;
            return value;
        }
        return dft;
    }

    public static enum AlgorithmEnum {
        LAYER,
        INMEM;

    }
}

