/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.MergeCuboidJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMergeJobBuilder
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchMergeJobBuilder.class);
    private final IMROutput.IMRBatchMergeOutputSide outputSide;

    public BatchMergeJobBuilder(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        Preconditions.checkArgument((!mergeSegment.isEnableSharding() ? 1 : 0) != 0, (Object)"V1 job engine does not support merging sharded cubes");
        this.outputSide = MRUtil.getBatchMergeOutputSide(mergeSegment);
    }

    public CubingJob build() {
        logger.info("MR_V1 new job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        List mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)("there should be more than 2 segments to merge, target segment " + cubeSegment));
        ArrayList mergingSegmentIds = Lists.newArrayList();
        ArrayList mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
            mergingCuboidPaths.add(this.getCuboidRootPath(merging) + "*");
        }
        result.addTask(this.createMergeDictionaryStep(mergingSegmentIds));
        String formattedPath = StringUtil.join((Iterable)mergingCuboidPaths, (String)",");
        result.addTask(this.createMergeCuboidDataStep(cubeSegment, formattedPath, cuboidRootPath));
        this.outputSide.addStepPhase2_BuildCube(result, cuboidRootPath);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    private MapReduceExecutable createMergeCuboidDataStep(CubeSegment seg, String inputPath, String outputPath) {
        MapReduceExecutable mergeCuboidDataStep = new MapReduceExecutable();
        mergeCuboidDataStep.setName("Merge Cuboid Data");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchMergeJobBuilder.appendExecCmdParameters(cmd, "cubename", seg.getCubeInstance().getName());
        BatchMergeJobBuilder.appendExecCmdParameters(cmd, "segmentid", seg.getUuid());
        BatchMergeJobBuilder.appendExecCmdParameters(cmd, "input", inputPath);
        BatchMergeJobBuilder.appendExecCmdParameters(cmd, "output", outputPath);
        BatchMergeJobBuilder.appendExecCmdParameters(cmd, "jobname", "Kylin_Merge_Cuboid_" + seg.getCubeInstance().getName() + "_Step");
        mergeCuboidDataStep.setMapReduceParams(cmd.toString());
        mergeCuboidDataStep.setMapReduceJobClass(MergeCuboidJob.class);
        return mergeCuboidDataStep;
    }
}

