/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.ddl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.spark.ddl.DDLCheck;
import org.apache.spark.ddl.DDLCheckContext;
import org.apache.spark.ddl.DDLConstant;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.springframework.security.acls.model.Permission;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SourceTableCheck
implements DDLCheck {
    public String[] description(String project, String pageType) {
        if ("hive".equalsIgnoreCase(pageType)) {
            return new String[]{"The source table used to define the view needs to be loaded into the data source already", "\u5b9a\u4e49 view \u7528\u5230\u7684\u6765\u6e90\u8868\u9700\u8981\u5df2\u7ecf\u52a0\u8f7d\u5230\u6570\u636e\u6e90"};
        }
        return new String[]{"The source tables in Logical View  should already be loaded into the project data source.Users can only load Logical View created in the same project into the data source", "\u5b9a\u4e49 Logical View \u7528\u5230\u7684\u6765\u6e90\u8868\u9700\u8981\u5df2\u7ecf\u52a0\u8f7d\u5230\u6570\u636e\u6e90,\u4e14\u7528\u6237\u4ec5\u80fd\u52a0\u8f7d\u540c\u4e00\u9879\u76ee\u4e0b\u521b\u5efa\u7684Logical View"};
    }

    public int priority() {
        return DDLConstant.SOURCE_TABLE_RULE_PRIORITY;
    }

    public void check(DDLCheckContext context) {
        SparkSession spark = SparderEnv.getSparkSession();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        LogicalPlan logicalPlan = null;
        this.checkACLPermission(context);
        try {
            logicalPlan = spark.sessionState().sqlParser().parsePlan(context.getSql());
        }
        catch (Throwable t) {
            this.throwException(t.getMessage());
        }
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)context.getProject());
        Seq relationLeaves = logicalPlan.collectLeaves();
        if (relationLeaves == null) {
            return;
        }
        List allTablesInProject = tableManager.listAllTables();
        for (LogicalPlan plan : (List)JavaConverters.seqAsJavaListConverter((Seq)relationLeaves).asJava()) {
            TableDesc table2;
            if (!(plan instanceof UnresolvedRelation)) continue;
            String tableName = ((UnresolvedRelation)plan).tableName();
            List loadTable = allTablesInProject.stream().filter(table -> table.getTableAlias().equalsIgnoreCase(tableName)).collect(Collectors.toList());
            if (loadTable.isEmpty()) {
                this.throwException(MsgPicker.getMsg().getDDLTableNotLoad(tableName));
            }
            if (0 != (table2 = (TableDesc)loadTable.get(0)).getSourceType() && 9 != table2.getSourceType() && 8 != table2.getSourceType()) {
                this.throwException(MsgPicker.getMsg().getDDLTableNotSupport(tableName));
            }
            if (!context.isLogicalViewCommand() || !table2.getDatabase().equalsIgnoreCase(config.getDDLLogicalViewDB())) continue;
            this.throwException(MsgPicker.getMsg().getDDLLogicalViewSourceTableError(tableName));
        }
    }

    private void checkACLPermission(DDLCheckContext context) {
        if (context.isHiveCommand() && !AclPermissionUtil.hasProjectAdminPermission((String)context.getProject(), (Set)context.getGroups())) {
            this.throwException("Only project administrator can do Hive operations");
        }
        if (!(context.isHiveCommand() || AclPermissionUtil.hasProjectAdminPermission((String)context.getProject(), (Set)context.getGroups()) || AclPermissionUtil.isSpecificPermissionInProject((String)context.getProject(), (Set)context.getGroups(), (Permission)AclPermission.MANAGEMENT))) {
            this.throwException("Only project administrator or modeler can do Logical View operations");
        }
    }
}

