/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.exception.JobSubmissionException;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.acl.AclTCRDigest;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.constant.SnapshotStatus;
import org.apache.kylin.rest.request.SnapshotRequest;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.NInitTablesResponse;
import org.apache.kylin.rest.response.SnapshotCheckResponse;
import org.apache.kylin.rest.response.SnapshotColResponse;
import org.apache.kylin.rest.response.SnapshotInfoResponse;
import org.apache.kylin.rest.response.SnapshotPartitionsResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.SnapshotSupporter;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.rest.util.TableUtils;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="snapshotService")
public class SnapshotService
extends BasicService
implements SnapshotSupporter {
    private static final List<String> SNAPSHOT_JOB_TYPES = Lists.newArrayList((Object[])new String[]{JobTypeEnum.SNAPSHOT_BUILD.name(), JobTypeEnum.SNAPSHOT_REFRESH.name()});
    private static final Logger logger = LoggerFactory.getLogger(SnapshotService.class);
    public static final String IS_REFRESH = "isRefresh";
    public static final String PRIORITY = "priority";
    public static final String YARN_QUEUE = "yarnQueue";
    public static final String TAG = "tag";
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private TableService tableService;

    private List<JobInfo> fetchAllRunningSnapshotTasksByTableIds(String project, Set<String> tableIds) {
        return ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).fetchNotFinalJobsByTypes(project, SNAPSHOT_JOB_TYPES, (List)(null == tableIds ? null : Lists.newArrayList(tableIds)));
    }

    private List<JobInfo> fetchAllRunningSnapshotTasks(String project, Set<TableDesc> tables) {
        Set<String> tableIds = tables.stream().map(ATable::getIdentity).collect(Collectors.toSet());
        return this.fetchAllRunningSnapshotTasksByTableIds(project, tableIds);
    }

    public JobInfoResponse buildSnapshots(SnapshotRequest snapshotsRequest, boolean isRefresh) {
        if (snapshotsRequest.getDatabases().isEmpty()) {
            return this.buildSnapshots(snapshotsRequest, isRefresh, snapshotsRequest.getTables());
        }
        Set dbs = snapshotsRequest.getDatabases().stream().map(db -> db.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        Map dbToTablesMap = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, snapshotsRequest.getProject())).dbToTablesMap(this.getConfig().isStreamingEnabled());
        Set nonExisted = dbs.stream().filter(db -> !dbToTablesMap.containsKey(db)).collect(Collectors.toSet());
        if (!nonExisted.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DATABASE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getDatabaseNotExist(), StringUtils.join(nonExisted, (String)", ")));
        }
        List<JobInfo> runningSnapshotTasks = this.fetchAllRunningSnapshotTasksByTableIds(snapshotsRequest.getProject(), null);
        Set tables = dbToTablesMap.entrySet().stream().filter(entry -> dbs.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).filter(table -> !this.hasLoadedSnapshot((TableDesc)table, runningSnapshotTasks)).filter(this::isAuthorizedTableAndColumn).map(ATable::getIdentity).collect(Collectors.toSet());
        snapshotsRequest.getTables().addAll(tables);
        return this.buildSnapshots(snapshotsRequest, isRefresh, snapshotsRequest.getTables());
    }

    public JobInfoResponse autoRefreshSnapshots(SnapshotRequest snapshotsRequest, boolean isRefresh) {
        String project = snapshotsRequest.getProject();
        Set needBuildSnapshotTables = snapshotsRequest.getTables();
        this.checkSnapshotManualManagement(project);
        Set<TableDesc> tables = this.checkAndGetTable(project, needBuildSnapshotTables);
        if (isRefresh) {
            this.checkTableSnapshotExist(project, this.checkAndGetTable(project, needBuildSnapshotTables));
        }
        this.checkOptions(tables, snapshotsRequest.getOptions());
        return this.buildSnapshotsInner(snapshotsRequest, isRefresh, needBuildSnapshotTables, tables);
    }

    public JobInfoResponse buildSnapshotsInner(SnapshotRequest snapshotsRequest, boolean isRefresh, Set<String> needBuildSnapshotTables, Set<TableDesc> tables) {
        String project = snapshotsRequest.getProject();
        Map options = snapshotsRequest.getOptions();
        ArrayList<String> invalidSnapshotsToBuild = new ArrayList<String>();
        SnapshotService.invalidSnapshotsToBuild(options, invalidSnapshotsToBuild);
        HashMap finalOptions = Maps.newHashMap();
        this.checkRunningSnapshotTask(project, needBuildSnapshotTables);
        JobManager.checkStorageQuota((String)project);
        ArrayList jobIds = new ArrayList();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.checkRunningSnapshotTask(project, needBuildSnapshotTables);
            JobManager.checkStorageQuota((String)project);
            for (TableDesc tableDesc : tables) {
                JobStatisticsManager jobStatisticsManager = JobStatisticsManager.getInstance((KylinConfig)this.getConfig(), (String)project);
                jobStatisticsManager.updateStatistics(TimeUtil.getDayStart((long)System.currentTimeMillis()), 0L, 0L, 1);
                SnapshotRequest.TableOption option = this.decideBuildOption(tableDesc, (SnapshotRequest.TableOption)options.get(tableDesc.getIdentity()));
                finalOptions.put(tableDesc.getIdentity(), option);
                logger.info("create snapshot job with args, table: {}, selectedPartCol: {}, selectedPartition{}, incrementBuild: {},isRefresh: {}", new Object[]{tableDesc.getIdentity(), option.getPartitionCol(), option.getPartitionsToBuild(), option.isIncrementalBuild(), isRefresh});
                JobTypeEnum jobType = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH : JobTypeEnum.SNAPSHOT_BUILD;
                String value = option.getPartitionsToBuild() == null ? null : JsonUtil.writeValueAsString((Object)option.getPartitionsToBuild());
                JobParam jobParam = new JobParam().withProject(project).withTable(tableDesc.getTableAlias()).withPriority(snapshotsRequest.getPriority()).withYarnQueue(snapshotsRequest.getYarnQueue()).withJobTypeEnum(jobType).withTag(snapshotsRequest.getTag()).withOwner(BasicService.getUsername()).addExtParams("incrementalBuild", String.valueOf(option.isIncrementalBuild())).addExtParams("selectedPartitionCol", option.getPartitionCol()).addExtParams("selectedPartition", value);
                jobIds.add(((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addJob(jobParam)));
            }
            this.updateTableDesc(project, tables, finalOptions);
            return null;
        }, (String)project);
        String jobName = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH.toString() : JobTypeEnum.SNAPSHOT_BUILD.toString();
        return JobInfoResponse.of(jobIds, (String)jobName);
    }

    private void updateTableDesc(String project, Set<TableDesc> tables, Map<String, SnapshotRequest.TableOption> finalOptions) {
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        for (TableDesc tableDesc : tables) {
            SnapshotRequest.TableOption option = finalOptions.get(tableDesc.getIdentity());
            if (!tableDesc.isSnapshotHasBroken() && StringUtils.equals((CharSequence)option.getPartitionCol(), (CharSequence)tableDesc.getSelectedSnapshotPartitionCol())) continue;
            TableDesc newTable = tableManager.copyForWrite(tableDesc);
            newTable.setSnapshotHasBroken(false);
            if (!StringUtils.equals((CharSequence)option.getPartitionCol(), (CharSequence)tableDesc.getSelectedSnapshotPartitionCol())) {
                newTable.setSelectedSnapshotPartitionCol(option.getPartitionCol());
            }
            tableManager.updateTableDesc(newTable);
        }
    }

    private static void invalidSnapshotsToBuild(Map<String, SnapshotRequest.TableOption> options, List<String> invalidSnapshotsToBuild) {
        for (Map.Entry<String, SnapshotRequest.TableOption> entry : options.entrySet()) {
            Set partitionToBuild = entry.getValue().getPartitionsToBuild();
            if (partitionToBuild == null || !partitionToBuild.isEmpty()) continue;
            invalidSnapshotsToBuild.add(entry.getKey());
        }
        if (!invalidSnapshotsToBuild.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getPartitionsToBuildCannotBeEmpty(invalidSnapshotsToBuild));
        }
    }

    public JobInfoResponse buildSnapshots(SnapshotRequest snapshotsRequest, boolean isRefresh, Set<String> needBuildSnapshotTables) {
        String project = snapshotsRequest.getProject();
        this.checkSnapshotManualManagement(project);
        Set<TableDesc> tables = this.checkAndGetTable(project, needBuildSnapshotTables);
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkTablePermission(tables);
        if (isRefresh) {
            this.checkTableSnapshotExist(project, this.checkAndGetTable(project, needBuildSnapshotTables));
        }
        this.checkOptions(tables, snapshotsRequest.getOptions());
        return this.buildSnapshotsInner(snapshotsRequest, isRefresh, needBuildSnapshotTables, tables);
    }

    private void checkOptions(Set<TableDesc> tables, Map<String, SnapshotRequest.TableOption> options) {
        for (TableDesc table : tables) {
            SnapshotRequest.TableOption option = options.get(table.getIdentity());
            if (option == null) continue;
            String partCol = option.getPartitionCol();
            this.checkSupportBuildSnapShotByPartition((ISourceAware)table);
            if (!StringUtils.isNotEmpty((CharSequence)partCol) || table.findColumnByName(partCol) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "table %s col %s not exist", table.getIdentity(), partCol));
        }
    }

    private SnapshotRequest.TableOption decideBuildOption(TableDesc tableDesc, SnapshotRequest.TableOption option) {
        boolean incrementalBuild = false;
        String selectedPartCol = null;
        Set partitionsToBuild = null;
        if (option != null) {
            selectedPartCol = StringUtils.isEmpty((CharSequence)option.getPartitionCol()) ? null : option.getPartitionCol();
            incrementalBuild = option.isIncrementalBuild();
            partitionsToBuild = option.getPartitionsToBuild();
        } else if (tableDesc.getLastSnapshotPath() != null) {
            selectedPartCol = tableDesc.getSelectedSnapshotPartitionCol();
            if (tableDesc.getSnapshotPartitionCol() != null) {
                incrementalBuild = true;
            }
        }
        if (!StringUtils.equals((CharSequence)selectedPartCol, (CharSequence)tableDesc.getSnapshotPartitionCol())) {
            incrementalBuild = false;
        }
        return new SnapshotRequest.TableOption(selectedPartCol, incrementalBuild, partitionsToBuild);
    }

    private void checkTablePermission(Set<TableDesc> tables) {
        List nonPermittedTables = tables.stream().filter(tableDesc -> !this.isAuthorizedTableAndColumn((TableDesc)tableDesc)).collect(Collectors.toList());
        if (!nonPermittedTables.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getSnapshotOperationPermissionDenied());
        }
    }

    @Transaction(project=0)
    public SnapshotCheckResponse deleteSnapshots(String project, Set<String> tableNames) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectOperationPermission(project);
        Set<TableDesc> tables = this.checkAndGetTable(project, tableNames);
        this.checkTablePermission(tables);
        this.checkTableSnapshotExist(project, tables);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        List<JobInfo> conflictJobs = this.fetchAllRunningSnapshotTasks(project, tables);
        List conflictJobIds = conflictJobs.stream().map(JobInfo::getJobId).collect(Collectors.toList());
        JobContextUtil.remoteDiscardJob((String)project, conflictJobIds);
        SnapshotCheckResponse response = new SnapshotCheckResponse();
        conflictJobs.forEach(job -> this.updateSnapshotCheckResponse((JobInfo)job, response));
        tableNames.forEach(tableName -> {
            TableDesc src = tableManager.getTableDesc(tableName);
            TableDesc copy = tableManager.copyForWrite(src);
            copy.deleteSnapshot(false);
            TableExtDesc ext = tableManager.getOrCreateTableExt(src);
            TableExtDesc extCopy = tableManager.copyForWrite(ext);
            extCopy.setOriginalSize(-1L);
            tableManager.mergeAndUpdateTableExt(ext, extCopy);
            tableManager.updateTableDesc(copy);
        });
        return response;
    }

    public SnapshotCheckResponse checkBeforeDeleteSnapshots(String project, Set<String> tableNames) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectOperationPermission(project);
        Set<TableDesc> tables = this.checkAndGetTable(project, tableNames);
        this.checkTablePermission(tables);
        this.checkTableSnapshotExist(project, tables);
        List<JobInfo> conflictJobs = this.fetchAllRunningSnapshotTasks(project, tables);
        SnapshotCheckResponse response = new SnapshotCheckResponse();
        conflictJobs.forEach(job -> this.updateSnapshotCheckResponse((JobInfo)job, response));
        return response;
    }

    private void updateSnapshotCheckResponse(JobInfo job, SnapshotCheckResponse response) {
        String tableIdentity = job.getSubject();
        String[] tableSplit = tableIdentity.split("\\.");
        String database = "";
        String table = tableIdentity;
        if (tableSplit.length >= 2) {
            database = tableSplit[0];
            table = tableSplit[1];
        }
        response.addAffectedJobs(job.getJobId(), database, table);
    }

    private void checkTableSnapshotExist(String project, Set<TableDesc> tables) {
        List<JobInfo> executables = this.fetchAllRunningSnapshotTasks(project, tables);
        List tablesWithEmptySnapshot = tables.stream().filter(tableDesc -> !this.hasLoadedSnapshot((TableDesc)tableDesc, executables)).map(ATable::getIdentity).collect(Collectors.toList());
        if (!tablesWithEmptySnapshot.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SNAPSHOT_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getSnapshotNotFound(), StringUtils.join(tablesWithEmptySnapshot, (String)"', '")));
        }
    }

    private void checkSnapshotManualManagement(String project) {
        if (!((NProjectManager)this.getManager(NProjectManager.class)).getProject(project).getConfig().isSnapshotManualManagementEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SNAPSHOT_MANAGEMENT_NOT_ENABLED, MsgPicker.getMsg().getSnapshotManagementNotEnabled());
        }
    }

    private void checkRunningSnapshotTask(String project, Set<String> needBuildSnapshotTables) {
        List<JobInfo> executables = this.fetchAllRunningSnapshotTasksByTableIds(project, needBuildSnapshotTables);
        HashSet<String> runningTables = new HashSet<String>();
        for (JobInfo executable : executables) {
            if (!needBuildSnapshotTables.contains(executable.getSubject())) continue;
            runningTables.add(executable.getSubject());
        }
        if (!runningTables.isEmpty()) {
            JobSubmissionException jobSubmissionException = new JobSubmissionException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_FAIL, new Object[0]);
            runningTables.forEach(tableName -> jobSubmissionException.addJobFailInfo(tableName, new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_FAIL, new Object[0])));
            throw jobSubmissionException;
        }
    }

    private Set<TableDesc> checkAndGetTable(String project, Set<String> needBuildSnapshotTables) {
        Preconditions.checkNotNull(needBuildSnapshotTables);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        HashSet<TableDesc> tables = new HashSet<TableDesc>();
        HashSet<String> notFoundTables = new HashSet<String>();
        for (String tableName : needBuildSnapshotTables) {
            TableDesc tableDesc = tableManager.getTableDesc(tableName);
            if (tableDesc != null) {
                tables.add(tableDesc);
                continue;
            }
            notFoundTables.add(tableName);
        }
        if (!notFoundTables.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), StringUtils.join(notFoundTables, (String)"', '")));
        }
        return tables;
    }

    public Pair<List<SnapshotInfoResponse>, Integer> getProjectSnapshots(String project, String table, Set<SnapshotStatus> statusFilter, Set<Boolean> partitionFilter, String sortBy, boolean isReversed, Pair<Integer, Integer> offsetAndLimit) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectReadPermission(project);
        NTableMetadataManager nTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        Pair databaseAndTable = this.checkDatabaseAndTable(table);
        Set groups = this.getCurrentUserGroups();
        boolean canUseACLGreenChannel = AclPermissionUtil.canUseACLGreenChannel((String)project, (Set)groups);
        Set<String> finalAuthorizedTables = this.getAclAuthorizedTables(project, canUseACLGreenChannel);
        List<JobInfo> executables = this.fetchAllRunningSnapshotTasksByTableIds(project, finalAuthorizedTables);
        List<TableDesc> tables = this.getFilteredTables(nTableMetadataManager, (Pair<String, String>)databaseAndTable, canUseACLGreenChannel, finalAuthorizedTables, executables, statusFilter, partitionFilter);
        ArrayList response = new ArrayList();
        int returnTableSize = TableUtils.calculateTableSize((int)((Integer)offsetAndLimit.getFirst()), (int)((Integer)offsetAndLimit.getSecond()));
        int actualTableSize = tables.size();
        AtomicInteger satisfiedTableSize = new AtomicInteger();
        tables.forEach(tableDesc -> {
            if (satisfiedTableSize.get() == returnTableSize) {
                return;
            }
            TableExtDesc tableExtDesc = nTableMetadataManager.getOrCreateTableExt(tableDesc);
            Pair<Integer, Integer> countPair = this.getModelCount((TableDesc)tableDesc);
            response.add(new SnapshotInfoResponse(tableDesc, tableExtDesc, tableDesc.getSnapshotTotalRows(), ((Integer)countPair.getFirst()).intValue(), ((Integer)countPair.getSecond()).intValue(), this.getSnapshotJobStatus((TableDesc)tableDesc, executables), this.getForbiddenColumns((TableDesc)tableDesc)));
            satisfiedTableSize.getAndIncrement();
        });
        String string = sortBy = StringUtils.isEmpty((CharSequence)sortBy) ? "last_modified_time" : sortBy;
        if ("last_modified_time".equalsIgnoreCase(sortBy) && isReversed) {
            response.sort(SnapshotInfoResponse::compareTo);
            return Pair.newPair((Object)PagingUtil.cutPage(response, (int)0, (int)((Integer)offsetAndLimit.getSecond())), (Object)actualTableSize);
        }
        Comparator comparator = BasicService.propertyComparator((String)sortBy, (!isReversed ? 1 : 0) != 0);
        response.sort(comparator);
        return Pair.newPair((Object)PagingUtil.cutPage(response, (int)((Integer)offsetAndLimit.getFirst()), (int)((Integer)offsetAndLimit.getSecond())), (Object)actualTableSize);
    }

    public Set<String> getAclAuthorizedTables(String project, boolean canUseACLGreenChannel) {
        Set<String> authorizedTables = new HashSet<String>();
        if (!canUseACLGreenChannel) {
            authorizedTables = this.getAuthorizedTables(project, (AclTCRManager)this.getManager(AclTCRManager.class, project));
        }
        return authorizedTables;
    }

    public List<TableDesc> getFilteredTables(NTableMetadataManager nTableMetadataManager, Pair<String, String> databaseAndTable, boolean canUseACLGreenChannel, Set<String> finalAuthorizedTables, List<JobInfo> executables, Set<SnapshotStatus> statusFilter, Set<Boolean> partitionFilter) {
        String finalDatabase = (String)databaseAndTable.getFirst();
        String finalTable = (String)databaseAndTable.getSecond();
        return nTableMetadataManager.listAllTables().stream().filter(tableDesc -> {
            if (StringUtils.isEmpty((CharSequence)finalDatabase)) {
                return true;
            }
            return tableDesc.getDatabase().equalsIgnoreCase(finalDatabase);
        }).filter(tableDesc -> {
            if (StringUtils.isEmpty((CharSequence)finalTable)) {
                return true;
            }
            if (finalDatabase == null && tableDesc.getDatabase().toLowerCase(Locale.ROOT).contains(finalTable.toLowerCase(Locale.ROOT))) {
                return true;
            }
            return tableDesc.getName().toLowerCase(Locale.ROOT).contains(finalTable.toLowerCase(Locale.ROOT));
        }).filter(tableDesc -> {
            if (canUseACLGreenChannel) {
                return true;
            }
            return finalAuthorizedTables.contains(tableDesc.getIdentity());
        }).filter(tableDesc -> this.hasLoadedSnapshot((TableDesc)tableDesc, executables)).filter(tableDesc -> statusFilter.isEmpty() || statusFilter.contains(this.getSnapshotJobStatus((TableDesc)tableDesc, executables))).filter(tableDesc -> {
            if (partitionFilter.size() != 1) {
                return true;
            }
            boolean isPartition = (Boolean)partitionFilter.iterator().next();
            return isPartition != (tableDesc.getSelectedSnapshotPartitionCol() == null);
        }).collect(Collectors.toList());
    }

    private Pair<Integer, Integer> getModelCount(TableDesc tableDesc) {
        int factCount = 0;
        int lookupCount = 0;
        NDataModelManager manager = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)tableDesc.getProject());
        for (NDataModel model : manager.listAllModels()) {
            if (model.isBroken()) continue;
            if (model.isRootFactTable(tableDesc)) {
                ++factCount;
                continue;
            }
            if (!model.isLookupTable(tableDesc)) continue;
            ++lookupCount;
        }
        return new Pair((Object)factCount, (Object)lookupCount);
    }

    private Set<String> getForbiddenColumns(TableDesc tableDesc) {
        String project = tableDesc.getProject();
        Set<Object> forbiddenColumns = Sets.newHashSet();
        Set groups = this.getCurrentUserGroups();
        if (AclPermissionUtil.canUseACLGreenChannel((String)project, (Set)groups)) {
            return forbiddenColumns;
        }
        String username = AclPermissionUtil.getCurrentUsername();
        AclTCRDigest userAuth = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, username, true);
        Set allColumns = userAuth.getColumns();
        for (String group : groups) {
            AclTCRDigest groupAuth = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, group, false);
            allColumns.addAll(groupAuth.getColumns());
        }
        forbiddenColumns = Sets.newHashSet((Object[])tableDesc.getColumns()).stream().map(columnDesc -> columnDesc.getTable().getIdentity() + "." + columnDesc.getName()).collect(Collectors.toSet());
        forbiddenColumns.removeAll(allColumns);
        return forbiddenColumns;
    }

    private SnapshotStatus getSnapshotJobStatus(TableDesc tableDesc, List<JobInfo> executables) {
        if (tableDesc.isSnapshotHasBroken()) {
            return SnapshotStatus.BROKEN;
        }
        boolean hasSnapshot = StringUtils.isNotEmpty((CharSequence)tableDesc.getLastSnapshotPath());
        boolean hasJob = this.hasRunningJob(tableDesc, executables);
        if (hasSnapshot) {
            if (hasJob) {
                return SnapshotStatus.REFRESHING;
            }
            return SnapshotStatus.ONLINE;
        }
        if (hasJob) {
            return SnapshotStatus.LOADING;
        }
        return SnapshotStatus.OFFLINE;
    }

    private boolean hasRunningJob(TableDesc tableDesc, List<JobInfo> executables) {
        return executables.stream().map(JobInfo::getSubject).collect(Collectors.toList()).contains(tableDesc.getIdentity());
    }

    private boolean isAuthorizedTableAndColumn(TableDesc originTable) {
        return this.isAuthorizedTableAndColumn(originTable, this.getCurrentUserGroups());
    }

    private boolean isAuthorizedTableAndColumn(TableDesc originTable, Set<String> groups) {
        String project = originTable.getProject();
        if (groups == null) {
            groups = this.getCurrentUserGroups();
        }
        if (AclPermissionUtil.canUseACLGreenChannel((String)project, (Set)groups)) {
            return true;
        }
        String username = AclPermissionUtil.getCurrentUsername();
        AclTCRDigest userAuth = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, username, true);
        Set allTables = userAuth.getTables();
        Set allColumns = userAuth.getColumns();
        for (String group : groups) {
            AclTCRDigest groupAuth = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, group, false);
            allTables.addAll(groupAuth.getTables());
            allColumns.addAll(groupAuth.getColumns());
        }
        if (!allTables.contains(originTable.getIdentity())) {
            return false;
        }
        return allColumns.containsAll(Lists.newArrayList((Object[])originTable.getColumns()).stream().map(columnDesc -> columnDesc.getTable().getIdentity() + "." + columnDesc.getName()).collect(Collectors.toList()));
    }

    private Set<String> getAuthorizedTables(String project, AclTCRManager aclTCRManager) {
        Set groups = this.getCurrentUserGroups();
        String username = AclPermissionUtil.getCurrentUsername();
        return ((Stream)Stream.concat(Stream.of(Pair.newPair((Object)username, (Object)true)), groups.stream().map(group -> Pair.newPair((Object)group, (Object)false))).parallel()).map(pair -> aclTCRManager.getAuthTablesAndColumns(project, (String)pair.getFirst(), ((Boolean)pair.getSecond()).booleanValue()).getTables()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean matchTablePattern(TableDesc tableDesc, String tablePattern, String databasePattern, String databaseTarget) {
        if (StringUtils.isEmpty((CharSequence)tablePattern)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)databasePattern) && databaseTarget.toLowerCase(Locale.ROOT).contains(tablePattern.toLowerCase(Locale.ROOT))) {
            return true;
        }
        return tableDesc.getName().toLowerCase(Locale.ROOT).contains(tablePattern.toLowerCase(Locale.ROOT));
    }

    public NInitTablesResponse getTables(String project, String tablePattern, int offset, int limit) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectReadPermission(project);
        String expectedDatabase = null;
        if (tablePattern.contains(".")) {
            expectedDatabase = tablePattern.split("\\.", 2)[0].trim();
            tablePattern = tablePattern.split("\\.", 2)[1].trim();
        }
        String finalTable = tablePattern;
        String finalDatabase = expectedDatabase;
        String finalExpectedDatabase = expectedDatabase;
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        List<JobInfo> jobInfoList = this.fetchAllRunningSnapshotTasksByTableIds(project, null);
        NInitTablesResponse response = new NInitTablesResponse();
        Set groups = this.getCurrentUserGroups();
        ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).dbToTablesMap(streamingEnabled).forEach((db, tableList) -> {
            if (finalExpectedDatabase != null && !db.equalsIgnoreCase(finalExpectedDatabase)) {
                return;
            }
            List tables = tableList.stream().filter(tableDesc -> this.matchTablePattern((TableDesc)tableDesc, finalTable, finalDatabase, (String)db)).filter(tableDesc -> this.isAuthorizedTableAndColumn((TableDesc)tableDesc, groups)).filter(table -> table.isAccessible(streamingEnabled)).sorted((arg_0, arg_1) -> ((TableService)this.tableService).compareTableDesc(arg_0, arg_1)).collect(Collectors.toList());
            int size = tables.size();
            List pageList = PagingUtil.cutPage(tables, (int)offset, (int)limit);
            if (!pageList.isEmpty()) {
                List tableResponse = pageList.stream().map(table -> new TableNameResponse(table.getName(), this.hasLoadedSnapshot((TableDesc)table, jobInfoList))).collect(Collectors.toList());
                response.putDatabase(db, size, tableResponse);
            }
        });
        return response;
    }

    private boolean hasLoadedSnapshot(TableDesc tableDesc, List<JobInfo> executables) {
        return tableDesc.isSnapshotHasBroken() || StringUtils.isNotEmpty((CharSequence)tableDesc.getLastSnapshotPath()) || this.hasRunningJob(tableDesc, executables);
    }

    public List<TableNameResponse> getTableNameResponses(String project, String database, String tablePattern) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectReadPermission(project);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        if (tablePattern == null) {
            tablePattern = "";
        }
        ArrayList<TableNameResponse> tableNameResponses = new ArrayList<TableNameResponse>();
        if (tablePattern.contains(".")) {
            String databasePattern = tablePattern.split("\\.", 2)[0].trim();
            if (!databasePattern.equalsIgnoreCase(database)) {
                return tableNameResponses;
            }
            tablePattern = tablePattern.split("\\.", 2)[1].trim();
        }
        Set groups = this.getCurrentUserGroups();
        String finalTable = tablePattern;
        List tables = tableManager.listAllTables().stream().filter(tableDesc -> tableDesc.getDatabase().equalsIgnoreCase(database)).filter(tableDesc -> {
            if (StringUtils.isEmpty((CharSequence)finalTable)) {
                return true;
            }
            return tableDesc.getName().toLowerCase(Locale.ROOT).contains(finalTable.toLowerCase(Locale.ROOT));
        }).filter(tableDesc -> this.isAuthorizedTableAndColumn((TableDesc)tableDesc, groups)).sorted((arg_0, arg_1) -> ((TableService)this.tableService).compareTableDesc(arg_0, arg_1)).collect(Collectors.toList());
        List<JobInfo> executables = this.fetchAllRunningSnapshotTasksByTableIds(project, tables.stream().map(ATable::getIdentity).collect(Collectors.toSet()));
        for (TableDesc tableDesc2 : tables) {
            TableNameResponse tableNameResponse = new TableNameResponse();
            tableNameResponse.setTableName(tableDesc2.getName());
            tableNameResponse.setLoaded(this.hasLoadedSnapshot(tableDesc2, executables));
            tableNameResponses.add(tableNameResponse);
        }
        return tableNameResponses;
    }

    private void checkSupportBuildSnapShotByPartition(ISourceAware sourceAware) {
        ISource source = SourceFactory.getSource((ISourceAware)sourceAware);
        if (!source.supportBuildSnapShotByPartition()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getJdbcNotSupportPartitionColumnInSnapshot());
        }
    }

    @Transaction(project=0)
    public void configSnapshotPartitionCol(String project, Map<String, String> table2PartCol) {
        this.checkSnapshotManualManagement(project);
        this.checkSupportBuildSnapShotByPartition((ISourceAware)((NProjectManager)this.getManager(NProjectManager.class)).getProject(project));
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkTableAndCol(project, table2PartCol);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        table2PartCol.forEach((tableName, colName) -> {
            TableDesc table = tableManager.copyForWrite(tableManager.getTableDesc(tableName));
            if (StringUtils.isEmpty((CharSequence)colName)) {
                colName = null;
            }
            colName = colName == null ? null : colName.toUpperCase(Locale.ROOT);
            table.setSelectedSnapshotPartitionCol(colName);
            tableManager.updateTableDesc(table);
        });
    }

    private void checkTableAndCol(String project, Map<String, String> table2PartCol) {
        if (table2PartCol.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"table_partition_col"});
        }
        Set<TableDesc> tables = this.checkAndGetTable(project, table2PartCol.keySet());
        this.checkTablePermission(tables);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        ArrayList notFoundCols = Lists.newArrayList();
        table2PartCol.forEach((tableName, colName) -> {
            TableDesc table = tableManager.getTableDesc(tableName);
            if (StringUtils.isNotEmpty((CharSequence)colName) && table.findColumnByName(colName) == null) {
                notFoundCols.add(tableName + "." + colName);
            }
        });
        if (!notFoundCols.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getColumnNotExist(), StringUtils.join((Iterable)notFoundCols, (String)"', '")));
        }
    }

    public List<SnapshotColResponse> getSnapshotCol(String project, Set<String> tables, Set<String> databases, String tablePattern, boolean includeExistSnapshot) {
        return this.getSnapshotCol(project, tables, databases, tablePattern, includeExistSnapshot, true);
    }

    public List<SnapshotColResponse> getSnapshotCol(String project, Set<String> tables, Set<String> databases, String tablePattern, boolean includeExistSnapshot, boolean excludeBroken) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectReadPermission(project);
        Set<String> finalTables = Optional.ofNullable(tables).orElse(Sets.newHashSet());
        Set<String> finalDatabase = Optional.ofNullable(databases).orElse(Sets.newHashSet());
        List allTables = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).listAllTables().stream().filter(table -> {
            if (finalDatabase.isEmpty() && finalTables.isEmpty()) {
                return true;
            }
            return finalTables.contains(table.getIdentity()) || finalDatabase.contains(table.getDatabase());
        }).filter(table -> {
            if (StringUtils.isEmpty((CharSequence)tablePattern)) {
                return true;
            }
            return table.getIdentity().toLowerCase(Locale.ROOT).contains(tablePattern.toLowerCase(Locale.ROOT));
        }).collect(Collectors.toList());
        List<JobInfo> executables = this.fetchAllRunningSnapshotTasksByTableIds(project, allTables.stream().map(ATable::getIdentity).collect(Collectors.toSet()));
        return allTables.stream().filter(table -> includeExistSnapshot || !this.hasLoadedSnapshot((TableDesc)table, executables) || !excludeBroken && table.isSnapshotHasBroken()).filter(this::isAuthorizedTableAndColumn).map(table -> SnapshotColResponse.from((TableDesc)table, this.tableSourceTypeTransformer((TableDesc)table))).collect(Collectors.toList());
    }

    public SnapshotColResponse reloadPartitionCol(String project, String table) {
        this.checkSnapshotManualManagement(project);
        this.aclEvaluate.checkProjectReadPermission(project);
        TableDesc newTableDesc = (TableDesc)((Pair)this.tableService.extractTableMeta(new String[]{table}, project).get(0)).getFirst();
        newTableDesc.init(project);
        return SnapshotColResponse.from((TableDesc)newTableDesc, this.tableSourceTypeTransformer(newTableDesc));
    }

    public Map<String, SnapshotPartitionsResponse> getPartitions(String project, Map<String, String> tablesAndCol) {
        HashMap responses = Maps.newHashMap();
        this.aclEvaluate.checkProjectReadPermission(project);
        Set<TableDesc> tableDescSet = this.checkAndGetTable(project, tablesAndCol.keySet());
        this.checkTablePermission(tableDescSet);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        tablesAndCol.forEach((table, v) -> {
            TableDesc tableDesc = tableManager.getTableDesc(table);
            SnapshotPartitionsResponse response = new SnapshotPartitionsResponse();
            ArrayList readyPartitions = Lists.newArrayList((Iterable)tableDesc.getReadyPartitions());
            readyPartitions.sort(String::compareTo);
            response.setReadyPartitions((List)readyPartitions);
            ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)tableDesc).getSourceMetadataExplorer();
            String userSelectPartitionCol = (String)tablesAndCol.get(table);
            if (tableDesc.getPartitionColumn() == null || !tableDesc.getPartitionColumn().equalsIgnoreCase(userSelectPartitionCol)) {
                responses.put(tableDesc.getDatabase() + "." + tableDesc.getName(), null);
                return;
            }
            Set allPartitions = explr.getTablePartitions(tableDesc.getDatabase(), tableDesc.getName(), tableDesc.getProject(), tableDesc.getPartitionColumn());
            allPartitions.removeAll(tableDesc.getReadyPartitions());
            ArrayList notReadyPartitions = Lists.newArrayList((Iterable)allPartitions);
            notReadyPartitions.sort(String::compareTo);
            response.setNotReadyPartitions((List)notReadyPartitions);
            responses.put(tableDesc.getDatabase() + "." + tableDesc.getName(), response);
        });
        return responses;
    }

    public UnaryOperator<SnapshotColResponse> tableSourceTypeTransformer(TableDesc table) {
        Map sourceProviderFamilyMapping = this.getConfig().getSourceProviderFamilyMapping();
        return res -> {
            boolean isMainSourceType = sourceProviderFamilyMapping.containsKey(table.getSourceType());
            if (!isMainSourceType) {
                sourceProviderFamilyMapping.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(table.getSourceType())).findFirst().ifPresent(entry -> res.setSourceType(((Integer)entry.getKey()).intValue()));
            }
            return res;
        };
    }
}

