/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class CommandLineParser {
    private final Configuration conf;
    public static final String MASTER_ADDRESSES_KEY = "kudu.master.addresses";
    public static final String MASTER_ADDRESSES_DEFAULT = "127.0.0.1";
    public static final String OPERATION_TIMEOUT_MS_KEY = "kudu.operation.timeout.ms";
    public static final long OPERATION_TIMEOUT_MS_DEFAULT = 30000L;
    public static final String ADMIN_OPERATION_TIMEOUT_MS_KEY = "kudu.admin.operation.timeout.ms";
    public static final String SOCKET_READ_TIMEOUT_MS_KEY = "kudu.socket.read.timeout.ms";
    public static final long SOCKET_READ_TIMEOUT_MS_DEFAULT = 10000L;
    public static final String NUM_REPLICAS_KEY = "kudu.num.replicas";
    public static final int NUM_REPLICAS_DEFAULT = 3;

    public CommandLineParser(Configuration conf) {
        this.conf = conf;
    }

    public String getMasterAddresses() {
        return this.conf.get(MASTER_ADDRESSES_KEY, MASTER_ADDRESSES_DEFAULT);
    }

    public long getOperationTimeoutMs() {
        return this.conf.getLong(OPERATION_TIMEOUT_MS_KEY, 30000L);
    }

    public long getAdminOperationTimeoutMs() {
        return this.conf.getLong(ADMIN_OPERATION_TIMEOUT_MS_KEY, 30000L);
    }

    public long getSocketReadTimeoutMs() {
        return this.conf.getLong(SOCKET_READ_TIMEOUT_MS_KEY, 10000L);
    }

    public int getNumReplicas() {
        return this.conf.getInt(NUM_REPLICAS_KEY, 3);
    }

    public AsyncKuduClient getAsyncClient() {
        return new AsyncKuduClient.AsyncKuduClientBuilder(this.getMasterAddresses()).defaultOperationTimeoutMs(this.getOperationTimeoutMs()).defaultAdminOperationTimeoutMs(this.getAdminOperationTimeoutMs()).defaultSocketReadTimeoutMs(this.getSocketReadTimeoutMs()).build();
    }

    public KuduClient getClient() {
        KuduClient c = new KuduClient.KuduClientBuilder(this.getMasterAddresses()).defaultOperationTimeoutMs(this.getOperationTimeoutMs()).defaultAdminOperationTimeoutMs(this.getAdminOperationTimeoutMs()).defaultSocketReadTimeoutMs(this.getSocketReadTimeoutMs()).build();
        KuduTableMapReduceUtil.importCredentialsFromCurrentSubject(c);
        return c;
    }

    public static String getHelpSnippet() {
        return "\nAdditionally, the following options are available:  -Dkudu.operation.timeout.ms=TIME - timeout for read and write operations, defaults to 30000 \n  -Dkudu.admin.operation.timeout.ms=TIME - timeout for admin operations , defaults to 30000 \n  -Dkudu.socket.read.timeout.ms=TIME - timeout for socket reads , defaults to 10000 \n  -Dkudu.master.addresses=ADDRESSES - addresses to reach the Masters, defaults to 127.0.0.1 which is usually wrong.\n  -D kudu.num.replicas=NUM - number of replicas to use when configuring a new table, defaults to 3";
    }
}

