/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.flume.sink;

import java.util.Collections;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.flume.sink.KuduEventProducer;

public class SimpleKuduEventProducer
implements KuduEventProducer {
    private byte[] payload;
    private KuduTable table;
    private String payloadColumn;

    public void configure(Context context) {
        this.payloadColumn = context.getString("payloadColumn", "payload");
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize(Event event, KuduTable table) {
        this.payload = event.getBody();
        this.table = table;
    }

    @Override
    public List<Operation> getOperations() throws FlumeException {
        try {
            Insert insert = this.table.newInsert();
            PartialRow row = insert.getRow();
            row.addBinary(this.payloadColumn, this.payload);
            return Collections.singletonList(insert);
        }
        catch (Exception e) {
            throw new FlumeException("Failed to create Kudu Insert object!", (Throwable)e);
        }
    }

    @Override
    public void close() {
    }
}

