/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.flume.sink;

import java.util.Collections;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.flume.sink.KuduEventProducer;

public class SimpleKeyedKuduEventProducer
implements KuduEventProducer {
    private byte[] payload;
    private String key;
    private KuduTable table;
    private String payloadColumn;
    private String keyColumn;
    private boolean upsert;

    public void configure(Context context) {
        this.payloadColumn = context.getString("payloadColumn", "payload");
        this.keyColumn = context.getString("keyColumn", "key");
        this.upsert = context.getBoolean("upsert", Boolean.valueOf(false));
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize(Event event, KuduTable table) {
        this.payload = event.getBody();
        this.key = (String)event.getHeaders().get(this.keyColumn);
        this.table = table;
    }

    @Override
    public List<Operation> getOperations() throws FlumeException {
        try {
            Upsert op = this.upsert ? this.table.newUpsert() : this.table.newInsert();
            PartialRow row = op.getRow();
            row.addString(this.keyColumn, this.key);
            row.addBinary(this.payloadColumn, this.payload);
            return Collections.singletonList(op);
        }
        catch (Exception e) {
            throw new FlumeException("Failed to create Kudu Operation object!", (Throwable)e);
        }
    }

    @Override
    public void close() {
    }
}

