/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.WireProtocol;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.tserver.Tserver;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Status {
    @VisibleForTesting
    static final int MAX_MESSAGE_LENGTH = 32768;
    @VisibleForTesting
    static final String ABBREVIATION_CHARS = "...";
    @VisibleForTesting
    static final int ABBREVIATION_CHARS_LENGTH = "...".length();
    private static final Status STATIC_OK = new Status(WireProtocol.AppStatusPB.ErrorCode.OK);
    private final WireProtocol.AppStatusPB.ErrorCode code;
    private final String message;
    private final int posixCode;

    private Status(WireProtocol.AppStatusPB.ErrorCode code, String msg, int posixCode) {
        this.code = code;
        this.posixCode = posixCode;
        this.message = msg.length() > 32768 ? msg.substring(0, 32768 - ABBREVIATION_CHARS_LENGTH) + ABBREVIATION_CHARS : msg;
    }

    private Status(WireProtocol.AppStatusPB appStatusPB) {
        this(appStatusPB.getCode(), appStatusPB.getMessage(), appStatusPB.getPosixCode());
    }

    private Status(WireProtocol.AppStatusPB.ErrorCode code, String msg) {
        this(code, msg, -1);
    }

    private Status(WireProtocol.AppStatusPB.ErrorCode code) {
        this(code, "", -1);
    }

    static Status fromMasterErrorPB(Master.MasterErrorPB masterErrorPB) {
        if (masterErrorPB == Master.MasterErrorPB.getDefaultInstance()) {
            return Status.OK();
        }
        return new Status(masterErrorPB.getStatus());
    }

    static Status fromTabletServerErrorPB(Tserver.TabletServerErrorPB tserverErrorPB) {
        if (tserverErrorPB == Tserver.TabletServerErrorPB.getDefaultInstance()) {
            return Status.OK();
        }
        return new Status(tserverErrorPB.getStatus());
    }

    static Status fromPB(WireProtocol.AppStatusPB pb) {
        return new Status(pb);
    }

    public static Status OK() {
        return STATIC_OK;
    }

    public static Status NotFound(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND, msg);
    }

    public static Status NotFound(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND, msg, posixCode);
    }

    public static Status Corruption(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.CORRUPTION, msg);
    }

    public static Status Corruption(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.CORRUPTION, msg, posixCode);
    }

    public static Status NotSupported(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_SUPPORTED, msg);
    }

    public static Status NotSupported(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_SUPPORTED, msg, posixCode);
    }

    public static Status InvalidArgument(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.INVALID_ARGUMENT, msg);
    }

    public static Status InvalidArgument(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.INVALID_ARGUMENT, msg, posixCode);
    }

    public static Status IOError(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.IO_ERROR, msg);
    }

    public static Status IOError(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.IO_ERROR, msg, posixCode);
    }

    public static Status AlreadyPresent(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT, msg);
    }

    public static Status AlreadyPresent(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT, msg, posixCode);
    }

    public static Status RuntimeError(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.RUNTIME_ERROR, msg);
    }

    public static Status RuntimeError(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.RUNTIME_ERROR, msg, posixCode);
    }

    public static Status NetworkError(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NETWORK_ERROR, msg);
    }

    public static Status NetworkError(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NETWORK_ERROR, msg, posixCode);
    }

    public static Status IllegalState(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE, msg);
    }

    public static Status IllegalState(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE, msg, posixCode);
    }

    public static Status NotAuthorized(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_AUTHORIZED, msg);
    }

    public static Status NotAuthorized(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.NOT_AUTHORIZED, msg, posixCode);
    }

    public static Status Aborted(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ABORTED, msg);
    }

    public static Status Aborted(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.ABORTED, msg, posixCode);
    }

    public static Status RemoteError(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.REMOTE_ERROR, msg);
    }

    public static Status RemoteError(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.REMOTE_ERROR, msg, posixCode);
    }

    public static Status ServiceUnavailable(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE, msg);
    }

    public static Status ServiceUnavailable(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE, msg, posixCode);
    }

    public static Status TimedOut(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.TIMED_OUT, msg);
    }

    public static Status TimedOut(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.TIMED_OUT, msg, posixCode);
    }

    public static Status Uninitialized(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.UNINITIALIZED, msg);
    }

    public static Status Uninitialized(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.UNINITIALIZED, msg, posixCode);
    }

    public static Status ConfigurationError(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.CONFIGURATION_ERROR, msg);
    }

    public static Status ConfigurationError(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.CONFIGURATION_ERROR, msg, posixCode);
    }

    public static Status Incomplete(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.INCOMPLETE, msg);
    }

    public static Status Incomplete(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.INCOMPLETE, msg, posixCode);
    }

    public static Status EndOfFile(String msg) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.END_OF_FILE, msg);
    }

    public static Status EndOfFile(String msg, int posixCode) {
        return new Status(WireProtocol.AppStatusPB.ErrorCode.END_OF_FILE, msg, posixCode);
    }

    public boolean ok() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.OK;
    }

    public boolean isCorruption() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.CORRUPTION;
    }

    public boolean isNotFound() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND;
    }

    public boolean isNotSupported() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.NOT_SUPPORTED;
    }

    public boolean isInvalidArgument() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.INVALID_ARGUMENT;
    }

    public boolean isIOError() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.IO_ERROR;
    }

    public boolean isAlreadyPresent() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT;
    }

    public boolean isRuntimeError() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.RUNTIME_ERROR;
    }

    public boolean isNetworkError() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.NETWORK_ERROR;
    }

    public boolean isIllegalState() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE;
    }

    public boolean isNotAuthorized() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.NOT_AUTHORIZED;
    }

    public boolean isAborted() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.ABORTED;
    }

    public boolean isRemoteError() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.REMOTE_ERROR;
    }

    public boolean isServiceUnavailable() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE;
    }

    public boolean isTimedOut() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.TIMED_OUT;
    }

    public boolean isUninitialized() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.UNINITIALIZED;
    }

    public boolean isConfigurationError() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.CONFIGURATION_ERROR;
    }

    public boolean isIncomplete() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.INCOMPLETE;
    }

    public boolean isEndOfFile() {
        return this.code == WireProtocol.AppStatusPB.ErrorCode.END_OF_FILE;
    }

    private String getCodeAsString() {
        switch (this.code.getNumber()) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Not found";
            }
            case 2: {
                return "Corruption";
            }
            case 3: {
                return "Not implemented";
            }
            case 4: {
                return "Invalid argument";
            }
            case 5: {
                return "IO error";
            }
            case 6: {
                return "Already present";
            }
            case 7: {
                return "Runtime error";
            }
            case 8: {
                return "Network error";
            }
            case 9: {
                return "Illegal state";
            }
            case 10: {
                return "Not authorized";
            }
            case 11: {
                return "Aborted";
            }
            case 12: {
                return "Remote error";
            }
            case 13: {
                return "Service unavailable";
            }
            case 14: {
                return "Timed out";
            }
            case 15: {
                return "Uninitialized";
            }
            case 16: {
                return "Configuration error";
            }
            case 17: {
                return "Incomplete";
            }
            case 18: {
                return "End of file";
            }
        }
        return "Unknown error (" + this.code.getNumber() + ")";
    }

    public int getPosixCode() {
        return this.posixCode;
    }

    String getCodeName() {
        return this.code.name();
    }

    String getMessage() {
        return this.message;
    }

    public String toString() {
        String str = this.getCodeAsString();
        if (this.code == WireProtocol.AppStatusPB.ErrorCode.OK) {
            return str;
        }
        str = String.format("%s: %s", str, this.message);
        if (this.posixCode != -1) {
            str = String.format("%s (error %d)", str, this.posixCode);
        }
        return str;
    }
}

