/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.Common;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;

class ConnectToClusterResponse {
    private static final ByteString FAKE_TABLET_ID = ByteString.copyFromUtf8("Kudu Master");
    private final HostAndPort leaderHostAndPort;
    private final Master.ConnectToMasterResponsePB connectResponse;

    public ConnectToClusterResponse(HostAndPort hostAndPort, Master.ConnectToMasterResponsePB connectResponse) {
        this.leaderHostAndPort = hostAndPort;
        this.connectResponse = connectResponse;
    }

    public Master.ConnectToMasterResponsePB getConnectResponse() {
        return this.connectResponse;
    }

    public HostAndPort getLeaderHostAndPort() {
        return this.leaderHostAndPort;
    }

    public Master.GetTableLocationsResponsePB getAsTableLocations() {
        return Master.GetTableLocationsResponsePB.newBuilder().addTabletLocations(Master.TabletLocationsPB.newBuilder().setPartition(Common.PartitionPB.newBuilder().setPartitionKeyStart(ByteString.EMPTY).setPartitionKeyEnd(ByteString.EMPTY)).setTabletId(FAKE_TABLET_ID).addReplicas(Master.TabletLocationsPB.ReplicaPB.newBuilder().setTsInfo(Master.TSInfoPB.newBuilder().addRpcAddresses(ProtobufHelper.hostAndPortToPB(this.leaderHostAndPort)).setPermanentUuid(ByteString.EMPTY)).setRole(this.connectResponse.getRole()))).build();
    }
}

