/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.com.google.protobuf.TextFormat;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.apache.kudu.rpc.RpcHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcOutboundMessage {
    private static final Logger LOG = LoggerFactory.getLogger(RpcOutboundMessage.class);
    private final RpcHeader.RequestHeader.Builder headerBuilder;
    private final Message body;

    RpcOutboundMessage(RpcHeader.RequestHeader.Builder header, Message body) {
        this.headerBuilder = header;
        this.body = body;
    }

    public RpcHeader.RequestHeader.Builder getHeaderBuilder() {
        return this.headerBuilder;
    }

    public Message getBody() {
        return this.body;
    }

    public String toString() {
        return "RpcOutboundMessage[header={" + TextFormat.shortDebugString(this.headerBuilder) + "}, body={" + TextFormat.shortDebugString(this.body) + "}]";
    }

    static class Encoder
    extends OneToOneEncoder {
        Encoder() {
        }

        @Override
        protected Object encode(ChannelHandlerContext ctx, Channel chan, Object obj) throws Exception {
            if (!(obj instanceof RpcOutboundMessage)) {
                return obj;
            }
            RpcOutboundMessage msg = (RpcOutboundMessage)obj;
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: sending RPC {}", (Object)chan, (Object)msg);
            }
            return KuduRpc.toChannelBuffer(msg.getHeaderBuilder().build(), msg.getBody());
        }
    }
}

