/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kudu.annotations.InterfaceAudience;

@InterfaceAudience.Private
public class RequestTracker {
    private final AtomicLong sequenceIdTracker = new AtomicLong();
    private final Queue<Long> incompleteRpcs = new PriorityBlockingQueue<Long>();
    static final long NO_SEQ_NO = -1L;
    private final String clientId;

    public RequestTracker(String clientId) {
        this.clientId = clientId;
    }

    public long newSeqNo() {
        Long next = this.sequenceIdTracker.incrementAndGet();
        this.incompleteRpcs.add(next);
        return next;
    }

    public long firstIncomplete() {
        Long peek = this.incompleteRpcs.peek();
        return peek == null ? -1L : peek;
    }

    public void rpcCompleted(long sequenceId) {
        this.incompleteRpcs.remove(sequenceId);
    }

    public String getClientId() {
        return this.clientId;
    }
}

