/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.DeleteTableResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class DeleteTableRequest
extends KuduRpc<DeleteTableResponse> {
    static final String DELETE_TABLE = "DeleteTable";
    private final String name;

    DeleteTableRequest(KuduTable table, String name) {
        super(table);
        this.name = name;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.DeleteTableRequestPB.Builder builder = Master.DeleteTableRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return DeleteTableRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return DELETE_TABLE;
    }

    @Override
    Pair<DeleteTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.DeleteTableResponsePB.Builder builder = Master.DeleteTableResponsePB.newBuilder();
        DeleteTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        DeleteTableResponse response = new DeleteTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<DeleteTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

