/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.Status;
import org.apache.kudu.tserver.Tserver;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowError {
    private final Status status;
    private final Operation operation;
    private final String tsUUID;

    RowError(Status status, Operation operation, String tsUUID) {
        this.status = status;
        this.operation = operation;
        this.tsUUID = tsUUID;
    }

    RowError(Status status, Operation operation) {
        this(status, operation, null);
    }

    public Status getErrorStatus() {
        return this.status;
    }

    @Deprecated
    public String getStatus() {
        return this.status.getCodeName();
    }

    @Deprecated
    public String getMessage() {
        return this.status.getMessage();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTsUUID() {
        return this.tsUUID;
    }

    public String toString() {
        return "Row error for row=" + this.operation.getRow() + ", tablet=" + this.operation.getTablet() + ", server=" + this.tsUUID + ", status=" + this.status.toString();
    }

    static RowError fromRowErrorPb(Tserver.WriteResponsePB.PerRowErrorPB errorPB, Operation operation, String tsUUID) {
        WireProtocol.AppStatusPB statusPB = errorPB.getError();
        return new RowError(Status.fromPB(statusPB), operation, tsUUID);
    }
}

