/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

public class HashUtil {
    private static final int HASH_VAL_NULL = 1476925031;
    private static final byte[] HASH_VAL_NULL_BYTE_BUF = new byte[4];
    private static final int HASH_VAL_EMPTY = 2110422766;
    private static final byte[] HASH_VAL_EMPTY_BYTE_BUF = new byte[4];

    private HashUtil() {
    }

    public static long fastHash64(byte[] buf, long seed) {
        long v;
        if (buf == null) {
            buf = HASH_VAL_NULL_BYTE_BUF;
        } else if (buf.length == 0) {
            buf = HASH_VAL_EMPTY_BYTE_BUF;
        }
        int len = buf.length;
        long m = -8645972361240307355L;
        long h = seed ^ (long)len * -8645972361240307355L;
        int len8 = len / 8;
        for (int i = 0; i < len8; ++i) {
            int pos = i * 8;
            v = (long)(buf[pos] & 0xFF) | (long)(buf[pos + 1] & 0xFF) << 8 | (long)(buf[pos + 2] & 0xFF) << 16 | (long)(buf[pos + 3] & 0xFF) << 24 | (long)(buf[pos + 4] & 0xFF) << 32 | (long)(buf[pos + 5] & 0xFF) << 40 | (long)(buf[pos + 6] & 0xFF) << 48 | (long)(buf[pos + 7] & 0xFF) << 56;
            h ^= HashUtil.fastHashMix(v);
            h *= -8645972361240307355L;
        }
        v = 0L;
        int pos2 = len8 * 8;
        switch (len & 7) {
            case 7: {
                v ^= (long)(buf[pos2 + 6] & 0xFF) << 48;
            }
            case 6: {
                v ^= (long)(buf[pos2 + 5] & 0xFF) << 40;
            }
            case 5: {
                v ^= (long)(buf[pos2 + 4] & 0xFF) << 32;
            }
            case 4: {
                v ^= (long)(buf[pos2 + 3] & 0xFF) << 24;
            }
            case 3: {
                v ^= (long)(buf[pos2 + 2] & 0xFF) << 16;
            }
            case 2: {
                v ^= (long)(buf[pos2 + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= HashUtil.fastHashMix(v ^= (long)(buf[pos2] & 0xFF));
                h *= -8645972361240307355L;
            }
        }
        return HashUtil.fastHashMix(h);
    }

    public static int fastHash32(byte[] buf, int seed) {
        long h = HashUtil.fastHash64(buf, seed);
        return (int)(h - (h >>> 32));
    }

    private static long fastHashMix(long h) {
        h ^= h >>> 23;
        h *= 2388976653695081527L;
        h ^= h >>> 47;
        return h;
    }

    static {
        HashUtil.HASH_VAL_NULL_BYTE_BUF[0] = 103;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[1] = 22;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[2] = 8;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[3] = 88;
        HashUtil.HASH_VAL_EMPTY_BYTE_BUF[0] = -18;
        HashUtil.HASH_VAL_EMPTY_BYTE_BUF[1] = 126;
        HashUtil.HASH_VAL_EMPTY_BYTE_BUF[2] = -54;
        HashUtil.HASH_VAL_EMPTY_BYTE_BUF[3] = 125;
    }
}

