/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.OptionalLong;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.transactions.Transactions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GetTransactionStateResponse
extends KuduRpcResponse {
    private final Transactions.TxnStatePB txnState;
    private final OptionalLong txnCommitTimestamp;

    GetTransactionStateResponse(long elapsedMillis, String serverUUID, Transactions.TxnStatePB txnState, OptionalLong txnCommitTimestamp) {
        super(elapsedMillis, serverUUID);
        this.txnState = txnState;
        this.txnCommitTimestamp = txnCommitTimestamp;
    }

    public Transactions.TxnStatePB txnState() {
        return this.txnState;
    }

    boolean hasCommitTimestamp() {
        return this.txnCommitTimestamp.isPresent();
    }

    long getCommitTimestamp() {
        Preconditions.checkState(this.hasCommitTimestamp());
        return this.txnCommitTimestamp.getAsLong();
    }

    public boolean isCommitted() {
        return this.txnState == Transactions.TxnStatePB.COMMITTED;
    }

    public boolean isAborted() {
        return this.txnState == Transactions.TxnStatePB.ABORTED;
    }
}

