/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class KuduMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(KuduMetrics.class);
    public static final String[] EMPTY_TAGS = new String[0];
    public static final KuduMetricId RPC_REQUESTS_METRIC = new KuduMetricId("rpc.requests", "A count of the sent request RPCs", "requests");
    public static final KuduMetricId RPC_RETRIES_METRIC = new KuduMetricId("rpc.retries", "A count of the retried request RPCs", "retries");
    public static final KuduMetricId RPC_RESPONSE_METRIC = new KuduMetricId("rpc.responses", "A count of the RPC responses received", "responses");
    public static final String CLIENT_ID_TAG = "client.id";
    public static final String SERVER_ID_TAG = "server.id";
    public static final String SERVICE_NAME_TAG = "service.name";
    public static final String METHOD_NAME_TAG = "method.name";
    private static boolean enabled = false;
    private static CompositeMeterRegistry registry = KuduMetrics.createDisabledRegistry();

    private KuduMetrics() {
    }

    public static synchronized void setEnabled(boolean enable) {
        if (enable && !enabled) {
            CompositeMeterRegistry oldRegistry = registry;
            registry = KuduMetrics.createRegistry();
            enabled = true;
            oldRegistry.close();
        } else if (!enable && enabled) {
            CompositeMeterRegistry oldRegistry = registry;
            registry = KuduMetrics.createDisabledRegistry();
            enabled = false;
            oldRegistry.close();
        }
    }

    private static CompositeMeterRegistry createRegistry() {
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        registry.config().namingConvention(NamingConvention.dot);
        registry.add(new SimpleMeterRegistry());
        return registry;
    }

    private static CompositeMeterRegistry createDisabledRegistry() {
        CompositeMeterRegistry registry = KuduMetrics.createRegistry();
        registry.config().meterFilter(MeterFilter.deny());
        return registry;
    }

    static int numMetrics() {
        return registry.getMeters().size();
    }

    static int numMetrics(KuduMetricId id) {
        return KuduMetrics.numMetrics(id, EMPTY_TAGS);
    }

    static int numMetrics(KuduMetricId id, String ... tags) {
        return Search.in(registry).name(id.name).tags(tags).counters().size();
    }

    static int numMetrics(String ... tags) {
        return Search.in(registry).tags(tags).counters().size();
    }

    static Counter counter(KuduMetricId id, String ... tags) {
        return Counter.builder(id.getName()).description(id.getDescription()).baseUnit(id.getUnit()).tags(tags).register(registry);
    }

    public static double totalCount(KuduMetricId id) {
        return KuduMetrics.totalCount(id, EMPTY_TAGS);
    }

    public static double totalCount(KuduMetricId id, String ... tags) {
        return Search.in(registry).name(id.name).tags(tags).counters().stream().mapToDouble(Counter::count).sum();
    }

    static void logMetrics() {
        registry.getMeters().stream().sorted(Comparator.comparing(m3 -> m3.getId().toString())).forEach(m3 -> {
            String tags = m3.getId().getTags().stream().sorted().map(t -> t.getKey() + "=" + t.getValue()).collect(Collectors.joining(",", "{", "}"));
            String key = m3.getId().getName() + " " + tags;
            String value = "unknown";
            if (m3 instanceof Counter) {
                value = ((Counter)m3).count() + " " + m3.getId().getBaseUnit();
            }
            LOG.info(key + " : " + value);
        });
    }

    private static class KuduMetricId {
        private final String name;
        private final String description;
        private final String unit;

        private KuduMetricId(String name, String description, String unit) {
            this.name = name;
            this.description = description;
            this.unit = unit;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

