/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Optional;
import java.util.function.ToLongFunction;

class JvmMemory {
    private JvmMemory() {
    }

    static Optional<MemoryPoolMXBean> getOldGen() {
        return ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class).stream().filter(JvmMemory::isHeap).filter(mem -> JvmMemory.isOldGenPool(mem.getName())).findAny();
    }

    static boolean isConcurrentPhase(String cause) {
        return "No GC".equals(cause);
    }

    static boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }

    static boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private static boolean isHeap(MemoryPoolMXBean memoryPoolBean) {
        return MemoryType.HEAP.equals((Object)memoryPoolBean.getType());
    }

    static double getUsageValue(MemoryPoolMXBean memoryPoolMXBean, ToLongFunction<MemoryUsage> getter) {
        MemoryUsage usage = JvmMemory.getUsage(memoryPoolMXBean);
        if (usage == null) {
            return Double.NaN;
        }
        return getter.applyAsLong(usage);
    }

    @Nullable
    private static MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError e) {
            return null;
        }
    }
}

