/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DateUtil {
    public static final int MIN_DATE_VALUE = (int)LocalDate.parse("0001-01-01").toEpochDay();
    public static final int MAX_DATE_VALUE = (int)LocalDate.parse("9999-12-31").toEpochDay();

    public static void checkDateWithinRange(long days) {
        if (days < (long)MIN_DATE_VALUE || days > (long)MAX_DATE_VALUE) {
            throw new IllegalArgumentException("Date value <" + days + ">} is out of range '0001-01-01':'9999-12-31'");
        }
    }

    public static int sqlDateToEpochDays(Date date) {
        long days = date.toLocalDate().toEpochDay();
        DateUtil.checkDateWithinRange(days);
        return (int)days;
    }

    public static Date epochDaysToSqlDate(int days) {
        DateUtil.checkDateWithinRange(days);
        return Date.valueOf(LocalDate.ofEpochDay(days));
    }

    public static String epochDaysToDateString(int days) {
        return LocalDate.ofEpochDay(days).toString();
    }
}

