/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.util.DataGenerator;
import org.apache.kudu.util.DecimalUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchemaGenerator {
    private static final int DEFAULT_BINARY_LENGTH = 128;
    private static final int MIN_HASH_BUCKETS = 2;
    private final Random random;
    private final int columnCount;
    private final int keyColumnCount;
    private final List<Type> types;
    private final List<Type> keyTypes;
    private final List<ColumnSchema.Encoding> encodings;
    private final List<ColumnSchema.CompressionAlgorithm> compressions;
    private final List<Integer> blockSizes;
    private final Float defaultRate;
    private final int minPrecision;
    private final int maxPrecision;

    private SchemaGenerator(Random random, int columnCount, int keyColumnCount, List<Type> types, List<Type> keyTypes, List<ColumnSchema.Encoding> encodings, List<ColumnSchema.CompressionAlgorithm> compressions, List<Integer> blockSizes, Float defaultRate, int minPrecision, int maxPrecision) {
        this.random = random;
        this.columnCount = columnCount;
        this.keyColumnCount = keyColumnCount;
        this.types = types;
        this.keyTypes = keyTypes;
        this.encodings = encodings;
        this.compressions = compressions;
        this.blockSizes = blockSizes;
        this.defaultRate = defaultRate;
        this.minPrecision = minPrecision;
        this.maxPrecision = maxPrecision;
    }

    public Schema randomSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean key = i < this.keyColumnCount;
            Type colType = this.randomType(key);
            String colName = colType.getName() + i;
            ColumnSchema column = this.randomColumnSchema(colName, colType, key);
            columns.add(column);
        }
        return new Schema(columns);
    }

    public ColumnSchema randomColumnSchema(String name, Type type, boolean key) {
        ColumnSchema.ColumnSchemaBuilder builder = new ColumnSchema.ColumnSchemaBuilder(name, type).key(key).nullable(this.random.nextBoolean() && !key).compressionAlgorithm(this.randomCompression()).desiredBlockSize(this.randomBlockSize()).encoding(this.randomEncoding(type)).comment("A " + type.getName() + " column for " + name);
        ColumnTypeAttributes typeAttributes = null;
        if (type == Type.DECIMAL) {
            int precision = this.random.nextInt(this.maxPrecision - this.minPrecision + 1) + this.minPrecision;
            int scale = this.random.nextInt(precision);
            typeAttributes = DecimalUtil.typeAttributes(precision, scale);
            builder.typeAttributes(typeAttributes);
        }
        if (this.random.nextFloat() <= this.defaultRate.floatValue()) {
            switch (type) {
                case BOOL: {
                    builder.defaultValue(this.random.nextBoolean());
                    break;
                }
                case INT8: {
                    builder.defaultValue((byte)this.random.nextInt());
                    break;
                }
                case INT16: {
                    builder.defaultValue((short)this.random.nextInt());
                    break;
                }
                case INT32: {
                    builder.defaultValue(this.random.nextInt());
                    break;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    builder.defaultValue(this.random.nextLong());
                    break;
                }
                case FLOAT: {
                    builder.defaultValue(Float.valueOf(this.random.nextFloat()));
                    break;
                }
                case DOUBLE: {
                    builder.defaultValue(this.random.nextDouble());
                    break;
                }
                case DECIMAL: {
                    builder.defaultValue(DataGenerator.randomDecimal(typeAttributes, this.random));
                    break;
                }
                case STRING: {
                    builder.defaultValue(DataGenerator.randomString(128, this.random));
                    break;
                }
                case BINARY: {
                    builder.defaultValue(DataGenerator.randomBinary(128, this.random));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type " + (Object)((Object)type));
                }
            }
        }
        return builder.build();
    }

    public int randomBlockSize() {
        return this.blockSizes.get(this.random.nextInt(this.blockSizes.size()));
    }

    public ColumnSchema.CompressionAlgorithm randomCompression() {
        return this.compressions.get(this.random.nextInt(this.compressions.size()));
    }

    public Type randomType(boolean key) {
        if (key) {
            return this.keyTypes.get(this.random.nextInt(this.keyTypes.size()));
        }
        return this.types.get(this.random.nextInt(this.types.size()));
    }

    public ColumnSchema.Encoding randomEncoding(Type type) {
        ArrayList<ColumnSchema.Encoding> validEncodings = new ArrayList<ColumnSchema.Encoding>(this.encodings);
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UNIXTIME_MICROS: {
                validEncodings.retainAll(Arrays.asList(ColumnSchema.Encoding.AUTO_ENCODING, ColumnSchema.Encoding.PLAIN_ENCODING, ColumnSchema.Encoding.BIT_SHUFFLE, ColumnSchema.Encoding.RLE));
                break;
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                validEncodings.retainAll(Arrays.asList(ColumnSchema.Encoding.AUTO_ENCODING, ColumnSchema.Encoding.PLAIN_ENCODING, ColumnSchema.Encoding.BIT_SHUFFLE));
                break;
            }
            case STRING: 
            case BINARY: {
                validEncodings.retainAll(Arrays.asList(ColumnSchema.Encoding.AUTO_ENCODING, ColumnSchema.Encoding.PLAIN_ENCODING, ColumnSchema.Encoding.PREFIX_ENCODING, ColumnSchema.Encoding.DICT_ENCODING));
                break;
            }
            case BOOL: {
                validEncodings.retainAll(Arrays.asList(ColumnSchema.Encoding.AUTO_ENCODING, ColumnSchema.Encoding.PLAIN_ENCODING, ColumnSchema.Encoding.RLE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
            }
        }
        if (validEncodings.size() == 0) {
            throw new IllegalArgumentException("There are no valid encodings for type " + (Object)((Object)type));
        }
        return (ColumnSchema.Encoding)((Object)validEncodings.get(this.random.nextInt(validEncodings.size())));
    }

    public CreateTableOptions randomCreateTableOptions(Schema schema) {
        CreateTableOptions options = new CreateTableOptions();
        List<ColumnSchema> keyColumns = schema.getPrimaryKeyColumns();
        int hashPartitionLevels = this.random.nextInt(Math.min(keyColumns.size(), 2)) + 1;
        for (int i = 0; i < hashPartitionLevels; ++i) {
            ColumnSchema hashColumn = keyColumns.get(i);
            int hashBuckets = this.random.nextInt(2) + 2;
            int hashSeed = this.random.nextInt();
            options.addHashPartitions(Arrays.asList(hashColumn.getName()), hashBuckets, hashSeed);
        }
        boolean hasRangePartition = this.random.nextBoolean();
        ColumnSchema int64Key = null;
        for (ColumnSchema col : keyColumns) {
            if (col.getType() != Type.INT64) continue;
            int64Key = col;
            break;
        }
        if (hasRangePartition && int64Key != null) {
            options.setRangePartitionColumns(Arrays.asList(int64Key.getName()));
            int splits = this.random.nextInt(8);
            ArrayList<Long> used = new ArrayList<Long>();
            int i = 0;
            while (i < splits) {
                PartialRow split = schema.newPartialRow();
                long value = this.random.nextLong();
                if (used.contains(value)) continue;
                used.add(value);
                split.addLong(int64Key.getName(), this.random.nextLong());
                ++i;
            }
        }
        return options;
    }

    public static class SchemaGeneratorBuilder {
        private Random random = new Random(System.currentTimeMillis());
        private int columnCount = 10;
        private int keyColumnCount = 1;
        private List<Type> types = Arrays.asList(Type.values());
        private List<ColumnSchema.Encoding> encodings = new ArrayList<ColumnSchema.Encoding>();
        private List<ColumnSchema.CompressionAlgorithm> compressions = new ArrayList<ColumnSchema.CompressionAlgorithm>();
        private List<Integer> blockSizes = Arrays.asList(0, 4096, 524288, 0x100000);
        private float defaultRate = 0.25f;
        private int minPrecision = 1;
        private int maxPrecision = 38;

        public SchemaGeneratorBuilder() {
            this.encodings.addAll(Arrays.asList(ColumnSchema.Encoding.values()));
            this.encodings.remove((Object)ColumnSchema.Encoding.UNKNOWN);
            this.compressions.addAll(Arrays.asList(ColumnSchema.CompressionAlgorithm.values()));
            this.compressions.remove((Object)ColumnSchema.CompressionAlgorithm.UNKNOWN);
        }

        public SchemaGeneratorBuilder random(Random random) {
            this.random = random;
            return this;
        }

        public SchemaGeneratorBuilder columnCount(int columnCount) {
            Preconditions.checkArgument(columnCount > 0, "columnCount must be greater than 0");
            this.columnCount = columnCount;
            return this;
        }

        public SchemaGeneratorBuilder keyColumnCount(int keyColumnCount) {
            Preconditions.checkArgument(this.columnCount > 0, "keyColumnCount must be greater than 0");
            this.keyColumnCount = keyColumnCount;
            return this;
        }

        public SchemaGeneratorBuilder types(Type ... types) {
            this.types = Arrays.asList(types);
            return this;
        }

        public SchemaGeneratorBuilder excludeTypes(Type ... types) {
            ArrayList<Type> includedTypes = new ArrayList<Type>();
            includedTypes.addAll(Arrays.asList(Type.values()));
            for (Type type : types) {
                includedTypes.remove((Object)type);
            }
            this.types = includedTypes;
            return this;
        }

        public SchemaGeneratorBuilder encodings(ColumnSchema.Encoding ... encodings) {
            this.encodings = Arrays.asList(encodings);
            return this;
        }

        public SchemaGeneratorBuilder compressions(ColumnSchema.CompressionAlgorithm ... compressions) {
            this.compressions = Arrays.asList(compressions);
            return this;
        }

        public SchemaGeneratorBuilder defaultRate(float defaultRate) {
            Preconditions.checkArgument(defaultRate >= 0.0f && defaultRate <= 1.0f, "defaultRate must be between 0 and 1");
            this.defaultRate = defaultRate;
            return this;
        }

        public SchemaGeneratorBuilder precision(int precision) {
            return this.precisionRange(precision, precision);
        }

        public SchemaGeneratorBuilder precisionRange(int minPrecision, int maxPrecision) {
            Preconditions.checkArgument(minPrecision >= 1, "minPrecision must be greater than or equal to 1");
            Preconditions.checkArgument(maxPrecision <= 38, "maxPrecision must be less than or equal to 38");
            Preconditions.checkArgument(minPrecision <= maxPrecision, "minPrecision must be less than or equal to " + maxPrecision);
            this.minPrecision = minPrecision;
            this.maxPrecision = maxPrecision;
            return this;
        }

        public SchemaGenerator build() {
            Preconditions.checkArgument(this.keyColumnCount <= this.columnCount, "keyColumnCount must be less than or equal to the columnCount");
            ArrayList<Type> keyTypes = new ArrayList<Type>(this.types);
            keyTypes.removeAll(Arrays.asList(Type.BOOL, Type.FLOAT, Type.DOUBLE));
            Preconditions.checkArgument(!keyTypes.isEmpty(), "At least one type must be supported for key columns");
            return new SchemaGenerator(this.random, this.columnCount, this.keyColumnCount, this.types, keyTypes, this.encodings, this.compressions, this.blockSizes, Float.valueOf(this.defaultRate), this.minPrecision, this.maxPrecision);
        }
    }
}

