/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTabletServersResponse;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ListTabletServersRequest
extends KuduRpc<ListTabletServersResponse> {
    public ListTabletServersRequest(KuduTable masterTable, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
    }

    @Override
    Message createRequestPB() {
        return Master.ListTabletServersRequestPB.getDefaultInstance();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "ListTabletServers";
    }

    @Override
    Pair<ListTabletServersResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.ListTabletServersResponsePB.Builder respBuilder = Master.ListTabletServersResponsePB.newBuilder();
        ListTabletServersRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int serversCount = respBuilder.getServersCount();
        ArrayList<String> servers = new ArrayList<String>(serversCount);
        for (Master.ListTabletServersResponsePB.Entry entry : respBuilder.getServersList()) {
            servers.add(entry.getRegistration().getRpcAddresses(0).getHost());
        }
        ListTabletServersResponse response = new ListTabletServersResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, serversCount, servers);
        return new Pair<ListTabletServersResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

