/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Iterator;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.Status;
import org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowResultIterator
extends KuduRpcResponse
implements Iterator<RowResult>,
Iterable<RowResult> {
    private static final RowResultIterator EMPTY = new RowResultIterator(0L, null, null, 0, null, null, false);
    private final Schema schema;
    private final Slice bs;
    private final Slice indirectBs;
    private final int numRows;
    private int currentRow = 0;
    private final RowResult sharedRowResult;

    private RowResultIterator(long elapsedMillis, String tsUUID, Schema schema, int numRows, Slice bs, Slice indirectBs, boolean reuseRowResult) {
        super(elapsedMillis, tsUUID);
        this.schema = schema;
        this.numRows = numRows;
        this.bs = bs;
        this.indirectBs = indirectBs;
        this.sharedRowResult = reuseRowResult && numRows != 0 ? new RowResult(this.schema, this.bs, this.indirectBs, -1) : null;
    }

    static RowResultIterator makeRowResultIterator(long elapsedMillis, String tsUUID, Schema schema, WireProtocol.RowwiseRowBlockPB data, CallResponse callResponse, boolean reuseRowResult) throws KuduException {
        int rowSize;
        if (data == null || data.getNumRows() == 0) {
            return new RowResultIterator(elapsedMillis, tsUUID, schema, 0, null, null, reuseRowResult);
        }
        Slice bs = callResponse.getSidecar(data.getRowsSidecar());
        Slice indirectBs = callResponse.getSidecar(data.getIndirectDataSidecar());
        int numRows = data.getNumRows();
        int expectedSize = numRows * (rowSize = schema.getRowSize());
        if (expectedSize != bs.length()) {
            Status statusIllegalState = Status.IllegalState("RowResult block has " + bs.length() + " bytes of data but expected " + expectedSize + " for " + numRows + " rows");
            throw new NonRecoverableException(statusIllegalState);
        }
        return new RowResultIterator(elapsedMillis, tsUUID, schema, numRows, bs, indirectBs, reuseRowResult);
    }

    public static RowResultIterator empty() {
        return EMPTY;
    }

    @Override
    public boolean hasNext() {
        return this.currentRow < this.numRows;
    }

    @Override
    public RowResult next() {
        if (this.sharedRowResult != null) {
            this.sharedRowResult.advancePointerTo(this.currentRow++);
            return this.sharedRowResult;
        }
        return new RowResult(this.schema, this.bs, this.indirectBs, this.currentRow++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String toString() {
        return "RowResultIterator for " + this.numRows + " rows";
    }

    @Override
    public Iterator<RowResult> iterator() {
        return this;
    }
}

