/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.IsAlterTableDoneResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IsAlterTableDoneRequest
extends KuduRpc<IsAlterTableDoneResponse> {
    private final Master.TableIdentifierPB.Builder tableId;

    IsAlterTableDoneRequest(KuduTable masterTable, Master.TableIdentifierPB.Builder tableId, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
        this.tableId = tableId;
    }

    @Override
    Message createRequestPB() {
        Master.IsAlterTableDoneRequestPB.Builder builder = Master.IsAlterTableDoneRequestPB.newBuilder();
        builder.setTable(this.tableId);
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "IsAlterTableDone";
    }

    @Override
    Pair<IsAlterTableDoneResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.IsAlterTableDoneResponsePB.Builder respBuilder = Master.IsAlterTableDoneResponsePB.newBuilder();
        IsAlterTableDoneRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        IsAlterTableDoneResponse resp = new IsAlterTableDoneResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, respBuilder.getDone());
        return new Pair<IsAlterTableDoneResponse, Object>(resp, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

