/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import java.util.Objects;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Common;
import org.apache.kudu.Compression;
import org.apache.kudu.Type;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnSchema {
    private final String name;
    private final Type type;
    private final boolean key;
    private final boolean nullable;
    private final Object defaultValue;
    private final int desiredBlockSize;
    private final Encoding encoding;
    private final CompressionAlgorithm compressionAlgorithm;
    private final ColumnTypeAttributes typeAttributes;
    private final int typeSize;
    private final Common.DataType wireType;
    private final String comment;

    private ColumnSchema(String name, Type type, boolean key, boolean nullable, Object defaultValue, int desiredBlockSize, Encoding encoding, CompressionAlgorithm compressionAlgorithm, ColumnTypeAttributes typeAttributes, Common.DataType wireType, String comment) {
        this.name = name;
        this.type = type;
        this.key = key;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.desiredBlockSize = desiredBlockSize;
        this.encoding = encoding;
        this.compressionAlgorithm = compressionAlgorithm;
        this.typeAttributes = typeAttributes;
        this.typeSize = type.getSize(typeAttributes);
        this.wireType = wireType;
        this.comment = comment;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getDesiredBlockSize() {
        return this.desiredBlockSize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public ColumnTypeAttributes getTypeAttributes() {
        return this.typeAttributes;
    }

    @InterfaceAudience.Private
    public Common.DataType getWireType() {
        return this.wireType;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.typeAttributes, that.typeAttributes) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.key, this.typeAttributes, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Column name: ");
        sb.append(this.name);
        sb.append(", type: ");
        sb.append(this.type.getName());
        if (this.typeAttributes != null) {
            sb.append(this.typeAttributes.toStringForType(this.type));
        }
        if (!this.comment.isEmpty()) {
            sb.append(", comment: ");
            sb.append(this.comment);
        }
        return sb.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class ColumnSchemaBuilder {
        private final String name;
        private final Type type;
        private boolean key = false;
        private boolean nullable = false;
        private Object defaultValue = null;
        private int desiredBlockSize = 0;
        private Encoding encoding = null;
        private CompressionAlgorithm compressionAlgorithm = null;
        private ColumnTypeAttributes typeAttributes = null;
        private Common.DataType wireType = null;
        private String comment = "";

        public ColumnSchemaBuilder(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public ColumnSchemaBuilder(ColumnSchema that) {
            this.name = that.name;
            this.type = that.type;
            this.key = that.key;
            this.nullable = that.nullable;
            this.defaultValue = that.defaultValue;
            this.desiredBlockSize = that.desiredBlockSize;
            this.encoding = that.encoding;
            this.compressionAlgorithm = that.compressionAlgorithm;
            this.typeAttributes = that.typeAttributes;
            this.wireType = that.wireType;
            this.comment = that.comment;
        }

        public ColumnSchemaBuilder key(boolean key) {
            this.key = key;
            return this;
        }

        public ColumnSchemaBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnSchemaBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColumnSchemaBuilder desiredBlockSize(int desiredBlockSize) {
            this.desiredBlockSize = desiredBlockSize;
            return this;
        }

        public ColumnSchemaBuilder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public ColumnSchemaBuilder compressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public ColumnSchemaBuilder typeAttributes(ColumnTypeAttributes typeAttributes) {
            if (this.type != Type.DECIMAL && typeAttributes != null) {
                throw new IllegalArgumentException("ColumnTypeAttributes are not used on " + (Object)((Object)this.type) + " columns");
            }
            this.typeAttributes = typeAttributes;
            return this;
        }

        @InterfaceAudience.Private
        public ColumnSchemaBuilder wireType(Common.DataType wireType) {
            this.wireType = wireType;
            return this;
        }

        public ColumnSchemaBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ColumnSchema build() {
            if (this.wireType == null) {
                this.wireType = this.type.getDataType(this.typeAttributes);
            }
            return new ColumnSchema(this.name, this.type, this.key, this.nullable, this.defaultValue, this.desiredBlockSize, this.encoding, this.compressionAlgorithm, this.typeAttributes, this.wireType, this.comment);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum CompressionAlgorithm {
        UNKNOWN(Compression.CompressionType.UNKNOWN_COMPRESSION),
        DEFAULT_COMPRESSION(Compression.CompressionType.DEFAULT_COMPRESSION),
        NO_COMPRESSION(Compression.CompressionType.NO_COMPRESSION),
        SNAPPY(Compression.CompressionType.SNAPPY),
        LZ4(Compression.CompressionType.LZ4),
        ZLIB(Compression.CompressionType.ZLIB);

        final Compression.CompressionType internalPbType;

        private CompressionAlgorithm(Compression.CompressionType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Compression.CompressionType getInternalPbType() {
            return this.internalPbType;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Encoding {
        UNKNOWN(Common.EncodingType.UNKNOWN_ENCODING),
        AUTO_ENCODING(Common.EncodingType.AUTO_ENCODING),
        PLAIN_ENCODING(Common.EncodingType.PLAIN_ENCODING),
        PREFIX_ENCODING(Common.EncodingType.PREFIX_ENCODING),
        GROUP_VARINT(Common.EncodingType.GROUP_VARINT),
        RLE(Common.EncodingType.RLE),
        DICT_ENCODING(Common.EncodingType.DICT_ENCODING),
        BIT_SHUFFLE(Common.EncodingType.BIT_SHUFFLE);

        final Common.EncodingType internalPbType;

        private Encoding(Common.EncodingType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Common.EncodingType getInternalPbType() {
            return this.internalPbType;
        }
    }
}

