/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.util.ByteVec;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
@NotThreadSafe
public class PartitionPruner {
    private final Deque<Pair<byte[], byte[]>> rangePartitions;

    private PartitionPruner(Deque<Pair<byte[], byte[]>> rangePartitions) {
        this.rangePartitions = rangePartitions;
    }

    private static PartitionPruner empty() {
        return new PartitionPruner(new ArrayDeque<Pair<byte[], byte[]>>());
    }

    public static PartitionPruner create(AbstractKuduScannerBuilder<?, ?> scanner) {
        Schema schema = scanner.table.getSchema();
        PartitionSchema partitionSchema = scanner.table.getPartitionSchema();
        PartitionSchema.RangeSchema rangeSchema = partitionSchema.getRangeSchema();
        Map<String, KuduPredicate> predicates = scanner.predicates;
        if (scanner.upperBoundPrimaryKey.length > 0 && Bytes.memcmp(scanner.lowerBoundPrimaryKey, scanner.upperBoundPrimaryKey) >= 0) {
            return PartitionPruner.empty();
        }
        for (KuduPredicate predicate : predicates.values()) {
            if (predicate.getType() != KuduPredicate.PredicateType.NONE) continue;
            return PartitionPruner.empty();
        }
        byte[] rangeLowerBound = PartitionPruner.pushPredicatesIntoLowerBoundRangeKey(schema, rangeSchema, predicates);
        byte[] rangeUpperBound = PartitionPruner.pushPredicatesIntoUpperBoundRangeKey(schema, rangeSchema, predicates);
        if (partitionSchema.isSimpleRangePartitioning()) {
            if (Bytes.memcmp(rangeLowerBound, scanner.lowerBoundPrimaryKey) < 0) {
                rangeLowerBound = scanner.lowerBoundPrimaryKey;
            }
            if (scanner.upperBoundPrimaryKey.length > 0 && (rangeUpperBound.length == 0 || Bytes.memcmp(rangeUpperBound, scanner.upperBoundPrimaryKey) > 0)) {
                rangeUpperBound = scanner.upperBoundPrimaryKey;
            }
        }
        ArrayList<Integer> hashBuckets = new ArrayList<Integer>(partitionSchema.getHashBucketSchemas().size());
        for (PartitionSchema.HashBucketSchema hashSchema : partitionSchema.getHashBucketSchemas()) {
            hashBuckets.add(PartitionPruner.pushPredicatesIntoHashBucket(schema, hashSchema, predicates));
        }
        int constrainedIndex = 0;
        if (rangeLowerBound.length > 0 || rangeUpperBound.length > 0) {
            constrainedIndex = hashBuckets.size();
        } else {
            for (int i = hashBuckets.size(); i > 0; --i) {
                if (hashBuckets.get(i - 1) == null) continue;
                constrainedIndex = i;
                break;
            }
        }
        ArrayList<Pair<ByteVec, ByteVec>> partitionKeyRanges = new ArrayList<Pair<ByteVec, ByteVec>>();
        partitionKeyRanges.add(new Pair<ByteVec, ByteVec>(ByteVec.create(), ByteVec.create()));
        ByteBuffer bucketBuf = ByteBuffer.allocate(4);
        bucketBuf.order(ByteOrder.BIG_ENDIAN);
        for (int hashIdx = 0; hashIdx < constrainedIndex; ++hashIdx) {
            boolean bl;
            boolean bl2 = bl = hashIdx + 1 == constrainedIndex && rangeUpperBound.length == 0;
            if (hashBuckets.get(hashIdx) != null) {
                int n = (Integer)hashBuckets.get(hashIdx);
                int bucketUpper = bl ? n + 1 : n;
                for (Pair pair : partitionKeyRanges) {
                    KeyEncoder.encodeHashBucket(n, (ByteVec)pair.getFirst());
                    KeyEncoder.encodeHashBucket(bucketUpper, (ByteVec)pair.getSecond());
                }
                continue;
            }
            PartitionSchema.HashBucketSchema hashBucketSchema = partitionSchema.getHashBucketSchemas().get(hashIdx);
            ArrayList<Pair<ByteVec, ByteVec>> newPartitionKeyRanges = new ArrayList<Pair<ByteVec, ByteVec>>(partitionKeyRanges.size() * hashBucketSchema.getNumBuckets());
            for (Pair pair : partitionKeyRanges) {
                for (int bucket = 0; bucket < hashBucketSchema.getNumBuckets(); ++bucket) {
                    int bucketUpper = bl ? bucket + 1 : bucket;
                    ByteVec lower = ((ByteVec)pair.getFirst()).clone();
                    ByteVec upper = ((ByteVec)pair.getFirst()).clone();
                    KeyEncoder.encodeHashBucket(bucket, lower);
                    KeyEncoder.encodeHashBucket(bucketUpper, upper);
                    newPartitionKeyRanges.add(new Pair<ByteVec, ByteVec>(lower, upper));
                }
            }
            partitionKeyRanges = newPartitionKeyRanges;
        }
        for (Pair pair : partitionKeyRanges) {
            ((ByteVec)pair.getFirst()).append(rangeLowerBound);
            ((ByteVec)pair.getSecond()).append(rangeUpperBound);
        }
        ArrayDeque<Pair<byte[], byte[]>> partitionKeyRangeBytes = new ArrayDeque<Pair<byte[], byte[]>>(partitionKeyRanges.size());
        for (Pair pair : partitionKeyRanges) {
            byte[] lower = ((ByteVec)pair.getFirst()).toArray();
            byte[] upper = ((ByteVec)pair.getSecond()).toArray();
            assert (upper.length == 0 || Bytes.memcmp(lower, upper) < 0);
            if (scanner.lowerBoundPartitionKey.length > 0 && (lower.length == 0 || Bytes.memcmp(lower, scanner.lowerBoundPartitionKey) < 0)) {
                lower = scanner.lowerBoundPartitionKey;
            }
            if (scanner.upperBoundPartitionKey.length > 0 && (upper.length == 0 || Bytes.memcmp(upper, scanner.upperBoundPartitionKey) > 0)) {
                upper = scanner.upperBoundPartitionKey;
            }
            if (upper.length != 0 && Bytes.memcmp(lower, upper) >= 0) continue;
            partitionKeyRangeBytes.add(new Pair<byte[], byte[]>(lower, upper));
        }
        return new PartitionPruner(partitionKeyRangeBytes);
    }

    public boolean hasMorePartitionKeyRanges() {
        return !this.rangePartitions.isEmpty();
    }

    public byte[] nextPartitionKey() {
        return this.rangePartitions.getFirst().getFirst();
    }

    public Pair<byte[], byte[]> nextPartitionKeyRange() {
        return this.rangePartitions.getFirst();
    }

    public void removePartitionKeyRange(byte[] upperBound) {
        Pair<byte[], byte[]> range;
        if (upperBound.length == 0) {
            this.rangePartitions.clear();
            return;
        }
        while (!this.rangePartitions.isEmpty() && Bytes.memcmp(upperBound, (range = this.rangePartitions.getFirst()).getFirst()) > 0) {
            this.rangePartitions.removeFirst();
            if (range.getSecond().length != 0 && Bytes.memcmp(upperBound, range.getSecond()) >= 0) continue;
            this.rangePartitions.addFirst(new Pair<byte[], byte[]>(upperBound, range.getSecond()));
            break;
        }
    }

    boolean shouldPrune(Partition partition) {
        for (Pair<byte[], byte[]> range : this.rangePartitions) {
            if (range.getSecond().length > 0 && Bytes.memcmp(range.getSecond(), partition.getPartitionKeyStart()) <= 0) continue;
            return partition.getPartitionKeyEnd().length > 0 && Bytes.memcmp(partition.getPartitionKeyEnd(), range.getFirst()) <= 0;
        }
        return true;
    }

    private static List<Integer> idsToIndexes(Schema schema, List<Integer> ids) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(ids.size());
        for (int id : ids) {
            indexes.add(schema.getColumnIndex(id));
        }
        return indexes;
    }

    private static boolean incrementKey(PartialRow row, List<Integer> keyIndexes) {
        for (int i = keyIndexes.size() - 1; i >= 0; --i) {
            if (!row.incrementColumn(keyIndexes.get(i))) continue;
            return true;
        }
        return false;
    }

    private static byte[] pushPredicatesIntoLowerBoundRangeKey(Schema schema, PartitionSchema.RangeSchema rangeSchema, Map<String, KuduPredicate> predicates) {
        int idx;
        ColumnSchema column;
        KuduPredicate predicate;
        PartialRow row = schema.newPartialRow();
        int pushedPredicates = 0;
        List<Integer> rangePartitionColumnIdxs = PartitionPruner.idsToIndexes(schema, rangeSchema.getColumns());
        Iterator<Integer> iterator = rangePartitionColumnIdxs.iterator();
        block6: while (iterator.hasNext() && (predicate = predicates.get((column = schema.getColumnByIndex(idx = iterator.next().intValue())).getName())) != null) {
            switch (predicate.getType()) {
                case RANGE: {
                    if (predicate.getLower() == null) break block6;
                }
                case EQUALITY: {
                    row.setRaw(idx, predicate.getLower());
                    ++pushedPredicates;
                    break;
                }
                case IS_NOT_NULL: {
                    break block6;
                }
                case IN_LIST: {
                    row.setRaw(idx, predicate.getInListValues()[0]);
                    ++pushedPredicates;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unexpected predicate type can not be pushed into key: %s", predicate));
                }
            }
        }
        if (pushedPredicates == 0) {
            return AsyncKuduClient.EMPTY_ARRAY;
        }
        ListIterator<Integer> remainingIdxs = rangePartitionColumnIdxs.listIterator(pushedPredicates);
        while (remainingIdxs.hasNext()) {
            row.setMin((Integer)remainingIdxs.next());
        }
        return KeyEncoder.encodeRangePartitionKey(row, rangeSchema);
    }

    private static byte[] pushPredicatesIntoUpperBoundRangeKey(Schema schema, PartitionSchema.RangeSchema rangeSchema, Map<String, KuduPredicate> predicates) {
        int idx;
        ColumnSchema column;
        KuduPredicate predicate;
        PartialRow row = schema.newPartialRow();
        int pushedPredicates = 0;
        KuduPredicate finalPredicate = null;
        List<Integer> rangePartitionColumnIdxs = PartitionPruner.idsToIndexes(schema, rangeSchema.getColumns());
        Iterator<Integer> iterator = rangePartitionColumnIdxs.iterator();
        block6: while (iterator.hasNext() && (predicate = predicates.get((column = schema.getColumnByIndex(idx = iterator.next().intValue())).getName())) != null) {
            switch (predicate.getType()) {
                case EQUALITY: {
                    row.setRaw(idx, predicate.getLower());
                    ++pushedPredicates;
                    finalPredicate = predicate;
                    break;
                }
                case RANGE: {
                    if (predicate.getUpper() == null) break block6;
                    row.setRaw(idx, predicate.getUpper());
                    ++pushedPredicates;
                    finalPredicate = predicate;
                    break block6;
                }
                case IS_NOT_NULL: {
                    break block6;
                }
                case IN_LIST: {
                    byte[][] values = predicate.getInListValues();
                    row.setRaw(idx, values[values.length - 1]);
                    ++pushedPredicates;
                    finalPredicate = predicate;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unexpected predicate type can not be pushed into key: %s", predicate));
                }
            }
        }
        if (pushedPredicates == 0) {
            return AsyncKuduClient.EMPTY_ARRAY;
        }
        if (finalPredicate.getType() == KuduPredicate.PredicateType.EQUALITY || finalPredicate.getType() == KuduPredicate.PredicateType.IN_LIST) {
            PartitionPruner.incrementKey(row, rangePartitionColumnIdxs.subList(0, pushedPredicates));
        }
        ListIterator<Integer> remainingIdxs = rangePartitionColumnIdxs.listIterator(pushedPredicates);
        while (remainingIdxs.hasNext()) {
            row.setMin((Integer)remainingIdxs.next());
        }
        return KeyEncoder.encodeRangePartitionKey(row, rangeSchema);
    }

    private static Integer pushPredicatesIntoHashBucket(Schema schema, PartitionSchema.HashBucketSchema hashSchema, Map<String, KuduPredicate> predicates) {
        List<Integer> columnIdxs = PartitionPruner.idsToIndexes(schema, hashSchema.getColumnIds());
        PartialRow row = schema.newPartialRow();
        for (int idx : columnIdxs) {
            ColumnSchema column = schema.getColumnByIndex(idx);
            KuduPredicate predicate = predicates.get(column.getName());
            if (predicate == null || predicate.getType() != KuduPredicate.PredicateType.EQUALITY) {
                return null;
            }
            row.setRaw(idx, predicate.getLower());
        }
        return KeyEncoder.getHashBucket(row, hashSchema);
    }
}

