/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.ListTabletsResponse;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class ListTabletsRequest
extends KuduRpc<ListTabletsResponse> {
    ListTabletsRequest() {
        super(null);
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Tserver.ListTabletsRequestPB.Builder builder = Tserver.ListTabletsRequestPB.newBuilder();
        return ListTabletsRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return "ListTablets";
    }

    @Override
    Pair<ListTabletsResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Tserver.ListTabletsResponsePB.Builder respBuilder = Tserver.ListTabletsResponsePB.newBuilder();
        ListTabletsRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int serversCount = respBuilder.getStatusAndSchemaCount();
        ArrayList<String> tablets = new ArrayList<String>(serversCount);
        for (Tserver.ListTabletsResponsePB.StatusAndSchemaPB info : respBuilder.getStatusAndSchemaList()) {
            tablets.add(info.getTabletStatus().getTabletId());
        }
        ListTabletsResponse response = new ListTabletsResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, tablets);
        return new Pair<ListTabletsResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

