/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class ListTablesRequest
extends KuduRpc<ListTablesResponse> {
    private final String nameFilter;

    ListTablesRequest(KuduTable masterTable, String nameFilter) {
        super(masterTable);
        this.nameFilter = nameFilter;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.ListTablesRequestPB.Builder builder = Master.ListTablesRequestPB.newBuilder();
        if (this.nameFilter != null) {
            builder.setNameFilter(this.nameFilter);
        }
        return ListTablesRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "ListTables";
    }

    @Override
    Pair<ListTablesResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.ListTablesResponsePB.Builder respBuilder = Master.ListTablesResponsePB.newBuilder();
        ListTablesRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int serversCount = respBuilder.getTablesCount();
        ArrayList<String> tables = new ArrayList<String>(serversCount);
        for (Master.ListTablesResponsePB.TableInfo info : respBuilder.getTablesList()) {
            tables.add(info.getName());
        }
        ListTablesResponse response = new ListTablesResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, tables);
        return new Pair<ListTablesResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

