/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import org.apache.kudu.Common;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum Type {
    INT8(Common.DataType.INT8, "int8"),
    INT16(Common.DataType.INT16, "int16"),
    INT32(Common.DataType.INT32, "int32"),
    INT64(Common.DataType.INT64, "int64"),
    BINARY(Common.DataType.BINARY, "binary"),
    STRING(Common.DataType.STRING, "string"),
    BOOL(Common.DataType.BOOL, "bool"),
    FLOAT(Common.DataType.FLOAT, "float"),
    DOUBLE(Common.DataType.DOUBLE, "double"),
    UNIXTIME_MICROS(Common.DataType.UNIXTIME_MICROS, "unixtime_micros");

    private final Common.DataType dataType;
    private final String name;
    private final int size;

    private Type(Common.DataType dataType, String name) {
        this.dataType = dataType;
        this.name = name;
        this.size = Type.getTypeSize(this.dataType);
    }

    public Common.DataType getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "Type: " + this.name + ", size: " + this.size;
    }

    static int getTypeSize(Common.DataType type) {
        switch (type) {
            case STRING: 
            case BINARY: {
                return 16;
            }
            case BOOL: 
            case INT8: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: 
            case FLOAT: {
                return 4;
            }
            case INT64: 
            case DOUBLE: 
            case UNIXTIME_MICROS: {
                return 8;
            }
        }
        throw new IllegalArgumentException("The provided data type doesn't map to know any known one.");
    }

    public static Type getTypeForDataType(Common.DataType type) {
        switch (type) {
            case STRING: {
                return STRING;
            }
            case BINARY: {
                return BINARY;
            }
            case BOOL: {
                return BOOL;
            }
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case UNIXTIME_MICROS: {
                return UNIXTIME_MICROS;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("The provided data type doesn't map to know any known one: " + type.getDescriptorForType().getFullName());
    }
}

