/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetMasterRegistrationResponse;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
public class GetMasterRegistrationRequest
extends KuduRpc<GetMasterRegistrationResponse> {
    private static final String GET_MASTER_REGISTRATION = "GetMasterRegistration";

    public GetMasterRegistrationRequest(KuduTable masterTable) {
        super(masterTable);
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.GetMasterRegistrationRequestPB.Builder builder = Master.GetMasterRegistrationRequestPB.newBuilder();
        return GetMasterRegistrationRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return GET_MASTER_REGISTRATION;
    }

    @Override
    Pair<GetMasterRegistrationResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.GetMasterRegistrationResponsePB.Builder respBuilder = Master.GetMasterRegistrationResponsePB.newBuilder();
        GetMasterRegistrationRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        Metadata.RaftPeerPB.Role role = Metadata.RaftPeerPB.Role.FOLLOWER;
        if (!respBuilder.hasError() || respBuilder.getError().getCode() != Master.MasterErrorPB.Code.CATALOG_MANAGER_NOT_INITIALIZED) {
            role = respBuilder.getRole();
        }
        GetMasterRegistrationResponse response = new GetMasterRegistrationResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, role, respBuilder.getRegistration(), respBuilder.getInstanceId());
        return new Pair<GetMasterRegistrationResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

