/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.client.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.client.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduScanToken
implements Comparable<KuduScanToken> {
    private final LocatedTablet tablet;
    private final Client.ScanTokenPB message;

    private KuduScanToken(LocatedTablet tablet, Client.ScanTokenPB message) {
        this.tablet = tablet;
        this.message = message;
    }

    public LocatedTablet getTablet() {
        return this.tablet;
    }

    public KuduScanner intoScanner(KuduClient client) throws Exception {
        return KuduScanToken.pbIntoScanner(this.message, client);
    }

    public byte[] serialize() throws IOException {
        byte[] buf = new byte[this.message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        this.message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public static KuduScanner deserializeIntoScanner(byte[] buf, KuduClient client) throws Exception {
        return KuduScanToken.pbIntoScanner(Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf)), client);
    }

    private static KuduScanner pbIntoScanner(Client.ScanTokenPB message, KuduClient client) throws Exception {
        Preconditions.checkArgument(!message.getFeatureFlagsList().contains(Client.ScanTokenPB.Feature.Unknown), "Scan token requires an unsupported feature. This Kudu client must be updated.");
        KuduTable table = client.openTable(message.getTableName());
        KuduScanner.KuduScannerBuilder builder = client.newScannerBuilder(table);
        ArrayList<Integer> columns = new ArrayList<Integer>(message.getProjectedColumnsCount());
        for (Common.ColumnSchemaPB column : message.getProjectedColumnsList()) {
            int columnIdx = table.getSchema().getColumnIndex(column.getName());
            ColumnSchema schema = table.getSchema().getColumnByIndex(columnIdx);
            Preconditions.checkArgument(column.getType() == schema.getType().getDataType(), String.format("Column types do not match for column %s", column.getName()));
            columns.add(columnIdx);
        }
        builder.setProjectedColumnIndexes(columns);
        for (Common.ColumnPredicatePB pred : message.getColumnPredicatesList()) {
            builder.addPredicate(KuduPredicate.fromPB(table.getSchema(), pred));
        }
        if (message.hasLowerBoundPrimaryKey()) {
            builder.lowerBoundRaw(message.getLowerBoundPrimaryKey().toByteArray());
        }
        if (message.hasUpperBoundPrimaryKey()) {
            builder.exclusiveUpperBoundRaw(message.getUpperBoundPrimaryKey().toByteArray());
        }
        if (message.hasLowerBoundPartitionKey()) {
            builder.lowerBoundPartitionKeyRaw(message.getLowerBoundPartitionKey().toByteArray());
        }
        if (message.hasUpperBoundPartitionKey()) {
            builder.exclusiveUpperBoundPartitionKeyRaw(message.getUpperBoundPartitionKey().toByteArray());
        }
        if (message.hasLimit()) {
            builder.limit(message.getLimit());
        }
        if (message.hasFaultTolerant()) {
            // empty if block
        }
        if (message.hasReadMode()) {
            switch (message.getReadMode()) {
                case READ_AT_SNAPSHOT: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT);
                    if (!message.hasSnapTimestamp()) break;
                    builder.snapshotTimestampRaw(message.getSnapTimestamp());
                    break;
                }
                case READ_LATEST: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_LATEST);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown read mode");
                }
            }
        }
        if (message.hasPropagatedTimestamp()) {
            // empty if block
        }
        if (message.hasCacheBlocks()) {
            builder.cacheBlocks(message.getCacheBlocks());
        }
        return builder.build();
    }

    @Override
    public int compareTo(KuduScanToken other) {
        if (!this.message.getTableName().equals(other.message.getTableName())) {
            throw new IllegalArgumentException("Scan tokens from different tables may not be compared");
        }
        return this.tablet.getPartition().compareTo(other.getTablet().getPartition());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class KuduScanTokenBuilder
    extends AbstractKuduScannerBuilder<KuduScanTokenBuilder, List<KuduScanToken>> {
        private long timeout;

        KuduScanTokenBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
            this.timeout = client.getDefaultOperationTimeoutMs();
        }

        public KuduScanTokenBuilder setTimeout(long timeoutMs) {
            this.timeout = timeoutMs;
            return this;
        }

        @Override
        public List<KuduScanToken> build() {
            ColumnSchema columnSchema;
            if (this.lowerBoundPartitionKey != AsyncKuduClient.EMPTY_ARRAY || this.upperBoundPartitionKey != AsyncKuduClient.EMPTY_ARRAY) {
                throw new IllegalArgumentException("Partition key bounds may not be set on KuduScanTokenBuilder");
            }
            for (Object predicate : this.predicates.values()) {
                if (((KuduPredicate)predicate).getType() != KuduPredicate.PredicateType.NONE) continue;
                return ImmutableList.of();
            }
            Client.ScanTokenPB.Builder proto = Client.ScanTokenPB.newBuilder();
            proto.setTableName(this.table.getName());
            if (this.projectedColumnNames != null) {
                for (String columnName : this.projectedColumnNames) {
                    columnSchema = this.table.getSchema().getColumn(columnName);
                    Preconditions.checkArgument(columnSchema != null, "unknown column %s", columnName);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), columnSchema);
                }
            } else if (this.projectedColumnIndexes != null) {
                Object predicate;
                predicate = this.projectedColumnIndexes.iterator();
                while (predicate.hasNext()) {
                    int columnIdx = (Integer)predicate.next();
                    columnSchema = this.table.getSchema().getColumnByIndex(columnIdx);
                    Preconditions.checkArgument(columnSchema != null, "unknown column index %s", columnIdx);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), columnSchema);
                }
            } else {
                for (ColumnSchema column : this.table.getSchema().getColumns()) {
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), column);
                }
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                proto.addColumnPredicates(predicate.toPB());
            }
            if (this.lowerBoundPrimaryKey != AsyncKuduClient.EMPTY_ARRAY && this.lowerBoundPrimaryKey.length > 0) {
                proto.setLowerBoundPrimaryKey(ZeroCopyLiteralByteString.copyFrom(this.lowerBoundPrimaryKey));
            }
            if (this.upperBoundPrimaryKey != AsyncKuduClient.EMPTY_ARRAY && this.upperBoundPrimaryKey.length > 0) {
                proto.setUpperBoundPrimaryKey(ZeroCopyLiteralByteString.copyFrom(this.upperBoundPrimaryKey));
            }
            if (this.lowerBoundPartitionKey != AsyncKuduClient.EMPTY_ARRAY && this.lowerBoundPartitionKey.length > 0) {
                proto.setLowerBoundPartitionKey(ZeroCopyLiteralByteString.copyFrom(this.lowerBoundPartitionKey));
            }
            if (this.upperBoundPartitionKey != AsyncKuduClient.EMPTY_ARRAY && this.upperBoundPartitionKey.length > 0) {
                proto.setUpperBoundPartitionKey(ZeroCopyLiteralByteString.copyFrom(this.upperBoundPartitionKey));
            }
            proto.setLimit(this.limit);
            proto.setReadMode(this.readMode.pbVersion());
            if (this.table.getAsyncClient().getLastPropagatedTimestamp() != -1L) {
                proto.setPropagatedTimestamp(this.client.getLastPropagatedTimestamp());
            }
            if (this.readMode == AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT && this.htTimestamp != -1L) {
                proto.setSnapTimestamp(this.htTimestamp);
            }
            proto.setCacheBlocks(this.cacheBlocks);
            try {
                List<LocatedTablet> tablets = this.table.getPartitionSchema().isSimpleRangePartitioning() ? this.table.getTabletsLocations(this.lowerBoundPrimaryKey.length == 0 ? null : this.lowerBoundPrimaryKey, this.upperBoundPrimaryKey.length == 0 ? null : this.upperBoundPrimaryKey, this.timeout) : this.table.getTabletsLocations(this.timeout);
                ArrayList<KuduScanToken> tokens = new ArrayList<KuduScanToken>(tablets.size());
                for (LocatedTablet tablet : tablets) {
                    Client.ScanTokenPB.Builder builder = proto.clone();
                    builder.setLowerBoundPartitionKey(ZeroCopyLiteralByteString.wrap(tablet.getPartition().partitionKeyStart));
                    builder.setUpperBoundPartitionKey(ZeroCopyLiteralByteString.wrap(tablet.getPartition().partitionKeyEnd));
                    tokens.add(new KuduScanToken(tablet, builder.build()));
                }
                return tokens;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

