/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.util.List;
import org.apache.kerby.kerberos.kdc.identitybackend.ZKUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class IdentityZNodeHelper {
    private static final String IDENTITIES_ZNODE_NAME = "identities";
    private static final String PRINCIPAL_NAME_ZNODE_NAME = "principalName";
    private static final String KEY_VERSION_ZNODE_NAME = "keyVersion";
    private static final String KDC_FLAGS_ZNODE_NAME = "kdcFlags";
    private static final String DISABLED_ZNODE_NAME = "disabled";
    private static final String LOCKED_ZNODE_NAME = "locked";
    private static final String EXPIRE_TIME_ZNODE_NAME = "expireTime";
    private static final String CREATED_TIME_ZNODE_NAME = "createdTime";
    private static final String KEYS_ZNODE_NAME = "keys";
    private static final String KEY_TYPE_ZNODE_NAME = "keyType";
    private static final String KEY_ZNODE_NAME = "keyData";
    private static final String ENCRYPTION_KEY_NO_ZNODE_NAME = "keyNo";
    private static String baseZNode = "/kerby";

    public static String getBaseZNode() {
        return baseZNode;
    }

    public static String getIdentitiesZNode() {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getBaseZNode(), IDENTITIES_ZNODE_NAME);
    }

    public static String getIndentityZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIdentitiesZNode(), principalName);
    }

    public static String getPrincipalNameZnode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), PRINCIPAL_NAME_ZNODE_NAME);
    }

    public static String getKeyVersionZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), KEY_VERSION_ZNODE_NAME);
    }

    public static String getKdcFlagsZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), KDC_FLAGS_ZNODE_NAME);
    }

    public static String getDisabledZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), DISABLED_ZNODE_NAME);
    }

    public static String getLockedZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), LOCKED_ZNODE_NAME);
    }

    public static String getExpireTimeZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), EXPIRE_TIME_ZNODE_NAME);
    }

    public static String getCreatedTimeZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), CREATED_TIME_ZNODE_NAME);
    }

    public static String getKeysZNode(String principalName) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getIndentityZNode(principalName), KEYS_ZNODE_NAME);
    }

    public static String getKeyTypeZNode(String principalName, String type) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getKeysZNode(principalName), type);
    }

    public static String getEncryptionKeyTypeZNode(String principalName, String type) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getKeyTypeZNode(principalName, type), KEY_TYPE_ZNODE_NAME);
    }

    public static String getEncryptionKeyZNode(String principalName, String type) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getKeyTypeZNode(principalName, type), KEY_ZNODE_NAME);
    }

    public static String getEncryptionKeyNoZNode(String principalName, String type) {
        return ZKUtil.joinZNode(IdentityZNodeHelper.getKeyTypeZNode(principalName, type), ENCRYPTION_KEY_NO_ZNODE_NAME);
    }

    public static List<String> getIdentityNames(ZooKeeper zk) throws KeeperException {
        List<String> identityNames = ZKUtil.listChildrenNoWatch(zk, IdentityZNodeHelper.getIdentitiesZNode());
        return identityNames;
    }
}

