/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.dbutils.DbUtils;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kdc.identitybackend.MySQLConfKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLIdentityBackend
extends AbstractIdentityBackend {
    private String keyInfoTable;
    private String identityTable;
    private static DruidDataSource dataSource = null;
    private static final Logger LOG = LoggerFactory.getLogger(MySQLIdentityBackend.class);

    public MySQLIdentityBackend(Config config) {
        this.setConfig(config);
    }

    public MySQLIdentityBackend() {
    }

    private void initializeDataSource(String driver, String url, String user, String password) throws SQLException {
        dataSource = new DruidDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setInitialSize(10);
        dataSource.setMinIdle(3);
        dataSource.setMaxActive(80);
        dataSource.setMaxWait(6000L);
        dataSource.setTestWhileIdle(true);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(180);
        dataSource.setLogAbandoned(true);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        dataSource.setTimeBetweenEvictionRunsMillis(90000L);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxOpenPreparedStatements(20);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(30);
        dataSource.setAsyncInit(true);
        dataSource.setFilters("stat");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInitialize() throws KrbException {
        LOG.info("Initializing the MySQL identity backend.");
        if (dataSource == null) {
            String driver = this.getConfig().getString((ConfigKey)MySQLConfKey.MYSQL_DRIVER, true);
            String user = this.getConfig().getString((ConfigKey)MySQLConfKey.MYSQL_USER, true);
            String password = this.getConfig().getString((ConfigKey)MySQLConfKey.MYSQL_PASSWORD, true);
            String urlString = this.getConfig().getString((ConfigKey)MySQLConfKey.MYSQL_URL, true);
            if (urlString == null || urlString.isEmpty()) {
                urlString = this.getBackendConfig().getString((ConfigKey)MySQLConfKey.MYSQL_URL, true);
            }
            try {
                this.initializeDataSource(driver, urlString, user, password);
            }
            catch (SQLException e) {
                LOG.error("Failed to initialize data source. " + e.toString());
                throw new KrbException("Failed to initialize data source.", (Throwable)e);
            }
        }
        DruidPooledConnection connection = null;
        ResultSet resCheckTable = null;
        PreparedStatement preInitialize = null;
        PreparedStatement preKdcRealm = null;
        ResultSet resKdcRealm = null;
        PreparedStatement preIdentity = null;
        PreparedStatement preKey = null;
        try {
            connection = dataSource.getConnection();
            resCheckTable = connection.getMetaData().getTables(null, null, "kdc_config", null);
            if (resCheckTable.next()) {
                String stmInitialize = "UPDATE `kdc_config` SET initialized = true WHERE id = 1";
                preInitialize = connection.prepareStatement(stmInitialize);
                preInitialize.executeUpdate();
                String stmKdcRealm = "SELECT realm FROM `kdc_config`";
                preKdcRealm = connection.prepareStatement(stmKdcRealm);
                resKdcRealm = preKdcRealm.executeQuery();
                if (!resKdcRealm.next()) throw new KrbException("Failed to get kdc config.");
                String realm = resKdcRealm.getString("realm").toLowerCase();
                this.identityTable = "`" + realm + "_identity`";
                this.keyInfoTable = "`" + realm + "_key`";
            } else {
                this.identityTable = "`kerby_identity`";
                this.keyInfoTable = "`kerby_key`";
            }
            String stmIdentity = "CREATE TABLE IF NOT EXISTS " + this.identityTable + " (principal varchar(255) NOT NULL, key_version INTEGER DEFAULT 1, kdc_flags INTEGER DEFAULT 0, disabled bool DEFAULT NULL, locked bool DEFAULT NULL, created_time BIGINT DEFAULT 0, expire_time BIGINT DEFAULT 0, PRIMARY KEY (principal) ) ENGINE=INNODB DEFAULT CHARSET=utf8;";
            preIdentity = connection.prepareStatement(stmIdentity);
            preIdentity.executeUpdate();
            String stmKey = "CREATE TABLE IF NOT EXISTS " + this.keyInfoTable + " (key_id INTEGER NOT NULL AUTO_INCREMENT, key_type VARCHAR(255) DEFAULT NULL, kvno INTEGER DEFAULT -1, key_value BLOB DEFAULT NULL, principal VARCHAR(255) NOT NULL,PRIMARY KEY (key_id), INDEX (principal), FOREIGN KEY (principal) REFERENCES " + this.identityTable + "(principal) ) ENGINE=INNODB DEFAULT CHARSET=utf8;";
            preKey = connection.prepareStatement(stmKey);
            preKey.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOG.error("Error occurred while initialize MySQL backend.", (Throwable)e);
                throw new KrbException("Failed to create table in database. ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resCheckTable);
                DbUtils.closeQuietly(preInitialize);
                DbUtils.closeQuietly(preKdcRealm);
                DbUtils.closeQuietly(resKdcRealm);
                DbUtils.closeQuietly(preIdentity);
                DbUtils.closeQuietly(preKey);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)resCheckTable);
        DbUtils.closeQuietly((Statement)preInitialize);
        DbUtils.closeQuietly((Statement)preKdcRealm);
        DbUtils.closeQuietly((ResultSet)resKdcRealm);
        DbUtils.closeQuietly((Statement)preIdentity);
        DbUtils.closeQuietly((Statement)preKey);
        DbUtils.closeQuietly((Connection)connection);
    }

    protected void doStop() throws KrbException {
        if (dataSource == null) {
            return;
        }
        dataSource.close();
        if (!dataSource.isClosed()) {
            throw new KrbException("Failed to close connection with MySQL.");
        }
        LOG.info("Succeeded in closing connection with MySQL.");
    }

    protected KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        int keyVersion = identity.getKeyVersion();
        int kdcFlags = identity.getKdcFlags();
        boolean disabled = identity.isDisabled();
        boolean locked = identity.isLocked();
        long createdTime = identity.getCreatedTime().getTime();
        long expireTime = identity.getExpireTime().getTime();
        Map keys = identity.getKeys();
        DruidPooledConnection connection = null;
        KrbIdentity duplicateIdentity = this.doGetIdentity(principalName);
        if (duplicateIdentity != null) {
            LOG.warn("The identity maybe duplicate.");
            return duplicateIdentity;
        }
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            String stmIdentity = "INSERT INTO " + this.identityTable + " (principal, key_version, kdc_flags, disabled, locked, created_time, expire_time) VALUES(?, ?, ?, ?, ?, ?, ?)";
            try (Object preIdentity = connection.prepareStatement(stmIdentity);){
                preIdentity.setString(1, principalName);
                preIdentity.setInt(2, keyVersion);
                preIdentity.setInt(3, kdcFlags);
                preIdentity.setBoolean(4, disabled);
                preIdentity.setBoolean(5, locked);
                preIdentity.setLong(6, createdTime);
                preIdentity.setLong(7, expireTime);
                preIdentity.executeUpdate();
            }
            for (Map.Entry entry : keys.entrySet()) {
                String stmKey = "INSERT INTO " + this.keyInfoTable + " (key_type, kvno, key_value, principal) VALUES(?, ?, ?, ?)";
                PreparedStatement preKey = connection.prepareStatement(stmKey);
                try {
                    preKey.setString(1, ((EncryptionType)entry.getKey()).getName());
                    preKey.setInt(2, ((EncryptionKey)entry.getValue()).getKvno());
                    preKey.setBlob(3, new SerialBlob(((EncryptionKey)entry.getValue()).getKeyData()));
                    preKey.setString(4, principalName);
                    preKey.executeUpdate();
                }
                finally {
                    if (preKey == null) continue;
                    preKey.close();
                }
            }
            connection.commit();
            preIdentity = identity;
            return preIdentity;
        }
        catch (SQLException e) {
            try {
                LOG.info("Transaction is being rolled back.");
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException ex) {
                throw new KrbException("Transaction roll back failed. ", (Throwable)ex);
            }
            LOG.error("Error occurred while adding identity.");
            throw new KrbException("Failed to add identity. ", (Throwable)e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        KrbIdentity krbIdentity;
        ResultSet resIdentity;
        PreparedStatement preIdentity;
        DruidPooledConnection connection;
        block8: {
            KrbIdentity krbIdentity2 = null;
            connection = null;
            preIdentity = null;
            resIdentity = null;
            connection = dataSource.getConnection();
            String stmIdentity = String.format("SELECT * FROM %s a left join %s b on a.principal = b.principal where a.principal = ?", this.identityTable, this.keyInfoTable);
            preIdentity = connection.prepareStatement(stmIdentity);
            preIdentity.setString(1, principalName);
            resIdentity = preIdentity.executeQuery();
            ArrayList<EncryptionKey> keys = new ArrayList<EncryptionKey>();
            if (!resIdentity.isBeforeFirst()) break block8;
            while (resIdentity.next()) {
                if (krbIdentity2 == null) {
                    krbIdentity2 = new KrbIdentity(principalName);
                    krbIdentity2.setKeyVersion(resIdentity.getInt("key_version"));
                    krbIdentity2.setKdcFlags(resIdentity.getInt("kdc_flags"));
                    krbIdentity2.setDisabled(resIdentity.getBoolean("disabled"));
                    krbIdentity2.setLocked(resIdentity.getBoolean("locked"));
                    krbIdentity2.setCreatedTime(new KerberosTime(resIdentity.getLong("created_time")));
                    krbIdentity2.setExpireTime(new KerberosTime(resIdentity.getLong("expire_time")));
                }
                int kvno = resIdentity.getInt("kvno");
                String keyType = resIdentity.getString("key_type");
                EncryptionType eType = EncryptionType.fromName((String)keyType);
                byte[] keyValue = resIdentity.getBytes("key_value");
                EncryptionKey key = new EncryptionKey(eType, keyValue, kvno);
                keys.add(key);
            }
            if (krbIdentity2 != null && keys.size() > 0) {
                krbIdentity2.addKeys(keys);
            }
            KrbIdentity krbIdentity3 = krbIdentity2;
            DbUtils.closeQuietly((Statement)preIdentity);
            DbUtils.closeQuietly((ResultSet)resIdentity);
            DbUtils.closeQuietly((Connection)connection);
            return krbIdentity3;
        }
        try {
            krbIdentity = null;
        }
        catch (SQLException e) {
            try {
                LOG.error("Error occurred while getting identity. " + e.toString());
                throw new KrbException("Failed to get identity. ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(preIdentity);
                DbUtils.closeQuietly(resIdentity);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)preIdentity);
        DbUtils.closeQuietly((ResultSet)resIdentity);
        DbUtils.closeQuietly((Connection)connection);
        return krbIdentity;
    }

    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        try {
            this.doDeleteIdentity(principalName);
            this.doAddIdentity(identity);
        }
        catch (KrbException e) {
            LOG.error("Error occurred while updating identity: " + principalName);
            throw new KrbException("Failed to update identity. ", (Throwable)e);
        }
        return this.getIdentity(principalName);
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        DruidPooledConnection connection = null;
        PreparedStatement preKey = null;
        PreparedStatement preIdentity = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            String stmKey = "DELETE FROM  " + this.keyInfoTable + " WHERE principal = ?";
            preKey = connection.prepareStatement(stmKey);
            preKey.setString(1, principalName);
            preKey.executeUpdate();
            String stmIdentity = "DELETE FROM " + this.identityTable + " WHERE principal = ? ";
            preIdentity = connection.prepareStatement(stmIdentity);
            preIdentity.setString(1, principalName);
            preIdentity.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.warn("Transaction is being rolled back.");
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (SQLException ex) {
                    throw new KrbException("Transaction roll back failed. ", (Throwable)ex);
                }
                LOG.error("Error occurred while deleting identity.");
                throw new KrbException("Failed to delete identity. ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(preIdentity);
                DbUtils.closeQuietly(preKey);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)preIdentity);
        DbUtils.closeQuietly((Statement)preKey);
        DbUtils.closeQuietly((Connection)connection);
    }

    protected Iterable<String> doGetIdentities() throws KrbException {
        ArrayList<String> identityNames = new ArrayList<String>();
        DruidPooledConnection connection = null;
        PreparedStatement preSmt = null;
        ResultSet result = null;
        try {
            connection = dataSource.getConnection();
            String statement = "SELECT * FROM " + this.identityTable;
            preSmt = connection.prepareStatement(statement);
            result = preSmt.executeQuery();
            while (result.next()) {
                identityNames.add(result.getString("principal"));
            }
            result.close();
            preSmt.close();
        }
        catch (SQLException e) {
            try {
                LOG.error("Error occurred while getting identities.", (Throwable)e);
                throw new KrbException("Failed to get identities. ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(preSmt);
                DbUtils.closeQuietly(result);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)preSmt);
        DbUtils.closeQuietly((ResultSet)result);
        DbUtils.closeQuietly((Connection)connection);
        return identityNames;
    }
}

