/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.kerby.kerberos.kdc.impl.NettyKdcHandler;
import org.apache.kerby.kerberos.kdc.impl.NettyKdcUdpServerHandler;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyKdcNetwork {
    private KdcContext kdcContext;
    private InetSocketAddress tcpAddress;
    private InetSocketAddress udpAddress;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventLoopGroup group;
    private DefaultEventExecutorGroup executorGroup;
    private static final Logger LOG = LoggerFactory.getLogger(NettyKdcNetwork.class);

    public void init(KdcContext kdcContext) {
        this.kdcContext = kdcContext;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.executorGroup = new DefaultEventExecutorGroup(10);
    }

    public void listen(InetSocketAddress tcpAddress, InetSocketAddress udpAddress) throws IOException {
        this.tcpAddress = tcpAddress;
        this.udpAddress = udpAddress;
    }

    public void start() throws Exception {
        try {
            this.doStart();
        }
        catch (Exception e) {
            LOG.error("Error occurred while starting the netty kdc network. " + e.toString());
            throw new KrbException("Error occurred while starting the netty kdc network. ", (Throwable)e);
        }
    }

    private void doStart() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler(this.createChannelInitializer());
        b.bind(this.tcpAddress.getPort()).sync();
        if (this.udpAddress != null) {
            this.startUDPServer();
        }
    }

    private void startUDPServer() throws InterruptedException {
        this.group = new NioEventLoopGroup();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new NettyKdcUdpServerHandler(this.kdcContext));
        b.bind(this.udpAddress.getPort()).sync();
    }

    private ChannelInitializer<SocketChannel> createChannelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new KrbMessageDecoder()});
                p.addLast((EventExecutorGroup)NettyKdcNetwork.this.executorGroup, "KDC_HANDLER", (ChannelHandler)new NettyKdcHandler(NettyKdcNetwork.this.kdcContext));
            }
        };
    }

    public synchronized void stop() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.udpAddress != null) {
            this.group.shutdownGracefully();
        }
        try {
            this.bossGroup.terminationFuture().sync();
            this.workerGroup.terminationFuture().sync();
            if (this.udpAddress != null) {
                this.group.terminationFuture().sync();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted when sync. " + e);
        }
    }

    static class KrbMessageDecoder
    extends LengthFieldBasedFrameDecoder {
        KrbMessageDecoder() {
            super(0x100000, 0, 4, 0, 4, true);
        }
    }
}

