/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyKdcHandler
extends ChannelInboundHandlerAdapter {
    private final KdcHandler myKdcHandler;
    private static final Logger LOG = LoggerFactory.getLogger(NettyKdcHandler.class);

    public NettyKdcHandler(KdcContext kdcContext) {
        this.myKdcHandler = new KdcHandler(kdcContext);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        byte[] msgBytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(msgBytes);
        ByteBuffer requestMessage = ByteBuffer.wrap(msgBytes);
        byteBuf.release();
        InetSocketAddress clientAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        boolean isTcp = true;
        try {
            ByteBuffer responseMessage = this.myKdcHandler.handleMessage(requestMessage, isTcp, clientAddress.getAddress());
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((ByteBuffer)responseMessage));
        }
        catch (Exception e) {
            LOG.error("Error occurred while processing request:" + e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.fireExceptionCaught(cause);
    }
}

