/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.tracker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;
import org.osgi.framework.BundleActivator;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="service-metadata-generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, inheritByDefault=false)
public class GenerateServiceMetadata
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="BNDExtension-Bundle-Activator")
    protected String activatorProperty;
    @Parameter(defaultValue="BNDExtension-Require-Capability")
    protected String requirementsProperty;
    @Parameter(defaultValue="BNDExtension-Provide-Capability")
    protected String capabilitiesProperty;
    @Parameter(defaultValue="${project.build.directory}/generated/karaf-tracker")
    protected String outputDirectory;
    @Parameter(defaultValue="project")
    protected String classLoader;
    @Parameter(defaultValue=".*")
    protected String artifactInclude;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean addSourceDirectory = false;
            ArrayList<String> requirements = new ArrayList<String>();
            ArrayList<String> capabilities = new ArrayList<String>();
            ClassFinder finder = this.createFinder(this.classLoader);
            List classes = finder.findAnnotatedClasses(Services.class);
            ArrayList<Class> activators = new ArrayList<Class>();
            for (Class clazz : classes) {
                URL classUrl = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
                URL outputDirectoryUrl = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                if (classUrl == null || !classUrl.getPath().startsWith(outputDirectoryUrl.getPath())) {
                    this.getLog().info((CharSequence)("Ignoring " + String.valueOf(classUrl)));
                    continue;
                }
                if (BundleActivator.class.isAssignableFrom(clazz)) {
                    activators.add(clazz);
                }
                this.writeServiceProperties(clazz);
                Services services = clazz.getAnnotation(Services.class);
                if (services != null) {
                    for (RequireService requireService : services.requires()) {
                        requirements.add(this.getRequirement(requireService));
                    }
                    for (RequireService requireService : services.provides()) {
                        capabilities.add(this.getCapability((ProvideService)requireService));
                    }
                }
                addSourceDirectory = true;
            }
            if (addSourceDirectory) {
                Resource resource = new Resource();
                resource.setDirectory(this.outputDirectory);
                this.project.addResource(resource);
            }
            this.project.getProperties().setProperty(this.requirementsProperty, String.join((CharSequence)",", requirements));
            this.project.getProperties().setProperty(this.capabilitiesProperty, String.join((CharSequence)",", capabilities));
            if (activators.size() == 1) {
                this.getLog().info((CharSequence)("Activator " + ((Class)activators.get(0)).getName()));
                this.project.getProperties().setProperty(this.activatorProperty, ((Class)activators.get(0)).getName());
            }
            this.project.getProperties().setProperty("BNDExtension-Private-Package", "org.apache.karaf.util.tracker");
            this.project.getProperties().setProperty("BNDPrependExtension-Import-Package", "!org.apache.karaf.util.tracker.annotation");
            List services = finder.findAnnotatedClasses(Service.class);
            TreeSet<String> packages = new TreeSet<String>();
            for (Class clazz : services) {
                this.getLog().info((CharSequence)("Service " + clazz.getCanonicalName()));
                packages.add(clazz.getPackage().getName());
            }
            if (!packages.isEmpty()) {
                this.project.getProperties().setProperty("BNDExtension-Karaf-Commands", String.join((CharSequence)",", packages));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    private String getRequirement(RequireService req) {
        String fltWithClass = this.combine(req.filter(), "(objectClass=" + req.value().getName() + ")");
        return "osgi.service;effective:=active;filter:=\"" + fltWithClass + "\"";
    }

    private String getCapability(ProvideService cap) {
        return "osgi.service;effective:=active;objectClass=" + cap.value().getName();
    }

    private void writeServiceProperties(Class<?> serviceClazz) throws IOException {
        Managed managed;
        Properties props = new Properties();
        Services services = serviceClazz.getAnnotation(Services.class);
        if (services != null) {
            for (RequireService req : services.requires()) {
                props.setProperty(req.value().getName(), req.filter());
            }
        }
        if ((managed = serviceClazz.getAnnotation(Managed.class)) != null) {
            props.setProperty("pid", managed.value());
        }
        File file = new File(this.outputDirectory, "OSGI-INF/karaf-tracker/" + serviceClazz.getName());
        file.getParentFile().mkdirs();
        this.writeProperties(props, file);
    }

    private void writeProperties(Properties props, File file) throws IOException {
        try (OutputStream os = this.buildContext.newFileOutputStream(file);
             PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "ISO-8859-1"));
             StringWriter sw = new StringWriter();){
            props.store(sw, null);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
    }

    private String combine(String filter1, String filter2) {
        if (filter1 != null && !filter1.isEmpty()) {
            return "(&" + filter2 + filter1 + ")";
        }
        return filter2;
    }

    private ClassFinder createFinder(String classloaderType) throws Exception {
        ClassFinder finder;
        if ("project".equals(classloaderType)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            for (Artifact artifact : this.project.getArtifacts()) {
                String name = artifact.getGroupId() + ":" + artifact.getArtifactId();
                if (this.artifactInclude != null && this.artifactInclude.length() > 0 && name.matches(this.artifactInclude)) {
                    File file = artifact.getFile();
                    if (file == null) continue;
                    this.getLog().debug((CharSequence)("Use artifact " + name + " " + String.valueOf(file)));
                    urls.add(file.toURI().toURL());
                    continue;
                }
                this.getLog().debug((CharSequence)("Ignore artifact " + name));
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            finder = new ClassFinder((ClassLoader)loader, urls);
        } else if ("plugin".equals(this.classLoader)) {
            finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
        }
        return finder;
    }
}

