/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.impl.action.command.HelpOption;
import org.apache.karaf.tooling.commands.AbstractCommandHelpPrinter;

public class UserConfCommandHelpPrinter
extends AbstractCommandHelpPrinter {
    @Override
    public void printHelp(Action action, PrintStream out, boolean includeHelpOption) {
        Command command = action.getClass().getAnnotation(Command.class);
        HashSet<Option> options = new HashSet<Option>();
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        HashMap<Argument, Field> argFields = new HashMap<Argument, Field>();
        HashMap optFields = new HashMap();
        for (Class<?> type = action.getClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    options.add(option);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                argument = this.replaceDefaultArgument(field, argument);
                argFields.put(argument, field);
                int index = argument.index();
                while (arguments.size() <= index) {
                    arguments.add(null);
                }
                if (arguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index + " on Action " + action.getClass().getName());
                }
                arguments.set(index, argument);
            }
        }
        if (includeHelpOption) {
            options.add(HelpOption.HELP);
        }
        out.println("h1. " + command.scope() + ":" + command.name());
        out.println();
        out.println("h2. Description");
        out.println(command.description());
        out.println();
        StringBuilder syntax = new StringBuilder();
        syntax.append(String.format("%s:%s", command.scope(), command.name()));
        if (options.size() > 0) {
            syntax.append(" \\[options\\]");
        }
        if (arguments.size() > 0) {
            syntax.append(' ');
            for (Argument argument : arguments) {
                syntax.append(String.format(argument.required() ? "%s " : "\\[%s\\] ", argument.name()));
            }
        }
        out.println("h2. Syntax");
        out.println(syntax.toString());
        out.println();
        if (arguments.size() > 0) {
            out.println("h2. Arguments");
            out.println("|| Name || Description ||");
            for (Argument argument : arguments) {
                Object o;
                String string;
                String description = argument.description();
                if (!argument.required() && (string = this.getDefaultValueString(o = this.getDefaultValue(action, (Field)argFields.get(argument)))) != null) {
                    description = description + " (defaults to " + o.toString() + ")";
                }
                out.println("| " + argument.name() + " | " + description + " |");
            }
            out.println();
        }
        if (options.size() > 0) {
            out.println("h2. Options");
            out.println("|| Name || Description ||");
            for (Option option : options) {
                StringBuilder opt = new StringBuilder(option.name());
                String desc = option.description();
                for (String alias : option.aliases()) {
                    opt.append(", ").append(alias);
                }
                Object object = this.getDefaultValue(action, (Field)optFields.get(option));
                String defaultValue = this.getDefaultValueString(object);
                if (defaultValue != null) {
                    desc = desc + " (defaults to " + defaultValue + ")";
                }
                out.println("| " + opt + " | " + desc + " |");
            }
            out.println();
        }
        if (command.detailedDescription().length() > 0) {
            out.println("h2. Details");
            out.println(command.detailedDescription());
        }
        out.println();
    }

    @Override
    public void printOverview(Map<String, Set<String>> commands, PrintStream writer) {
        writer.println("h1. Commands");
        writer.println();
        for (String key : commands.keySet()) {
            writer.println("h2. " + key);
            writer.println();
            for (String cmd : commands.get(key)) {
                writer.println("* [" + key + ":" + cmd + "|" + key + "-" + cmd + "]");
            }
            writer.println();
        }
    }
}

