/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.services.staticcm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import org.apache.karaf.services.staticcm.StaticConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class StaticConfigAdminImpl
implements ConfigurationAdmin {
    private final BundleContext context;
    private final List<Configuration> configurations;

    public StaticConfigAdminImpl(BundleContext context, List<Configuration> configs) throws IOException {
        Objects.requireNonNull(configs, "configs");
        this.context = context;
        this.configurations = configs;
        ServiceTracker<ManagedService, ManagedService> serviceTracker = new ServiceTracker<ManagedService, ManagedService>(context, ManagedService.class, null){

            public ManagedService addingService(ServiceReference<ManagedService> reference) {
                ManagedService service = (ManagedService)this.context.getService(reference);
                Object pidObj = reference.getProperty("service.pid");
                boolean found = false;
                if (pidObj instanceof String) {
                    String pid = (String)pidObj;
                    for (Configuration config : StaticConfigAdminImpl.this.configurations) {
                        if (!config.getPid().equals(pid) || config.getFactoryPid() != null) continue;
                        found = true;
                        StaticConfigAdminImpl.this.invokeUpdate(service, config);
                    }
                }
                if (!found) {
                    StaticConfigAdminImpl.this.invokeUpdate(service, null);
                }
                return service;
            }

            public void removedService(ServiceReference<ManagedService> reference, ManagedService service) {
                this.context.ungetService(reference);
            }
        };
        serviceTracker.open();
        ServiceTracker<ManagedServiceFactory, ManagedServiceFactory> factoryTracker = new ServiceTracker<ManagedServiceFactory, ManagedServiceFactory>(context, ManagedServiceFactory.class, null){

            public ManagedServiceFactory addingService(ServiceReference<ManagedServiceFactory> reference) {
                ManagedServiceFactory factory = (ManagedServiceFactory)this.context.getService(reference);
                Object pidObj = reference.getProperty("service.pid");
                if (pidObj instanceof String) {
                    String pid = (String)pidObj;
                    for (Configuration config : StaticConfigAdminImpl.this.configurations) {
                        if (!config.getPid().equals(pid) || config.getFactoryPid() == null) continue;
                        try {
                            factory.updated(config.getFactoryPid(), config.getProcessedProperties(null));
                        }
                        catch (ConfigurationException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.err.println("Unsupported pid: " + pidObj);
                }
                return factory;
            }

            public void removedService(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
                super.removedService(reference, (Object)service);
            }
        };
        factoryTracker.open();
    }

    private void invokeUpdate(ManagedService service, Configuration config) {
        try {
            service.updated(config == null ? null : config.getProcessedProperties(null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Configuration getConfiguration(String pid, String location) throws IOException {
        return this.getConfiguration(pid);
    }

    @Override
    public Configuration getConfiguration(String pid) throws IOException {
        for (Configuration config : this.configurations) {
            if (!config.getPid().equals(pid) || config.getFactoryPid() != null) continue;
            return config;
        }
        Hashtable<String, Object> cfg = new Hashtable<String, Object>();
        cfg.put("service.pid", pid);
        return new StaticConfigurationImpl(pid, null, cfg);
    }

    @Override
    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        List<Configuration> configs;
        if (filter == null) {
            configs = this.configurations;
        } else {
            configs = new ArrayList<Configuration>();
            Filter flt = this.context.createFilter(filter);
            for (Configuration config : this.configurations) {
                if (!flt.match(config.getProcessedProperties(null))) continue;
                configs.add(config);
            }
        }
        return configs.isEmpty() ? null : configs.toArray(new Configuration[configs.size()]);
    }

    @Override
    public Configuration getFactoryConfiguration(String factoryPid, String name, String location) throws IOException {
        throw new UnsupportedOperationException("getFactoryConfiguration");
    }

    @Override
    public Configuration getFactoryConfiguration(String factoryPid, String name) throws IOException {
        throw new UnsupportedOperationException("getFactoryConfiguration(pid,name)");
    }
}

