/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import java.util.Map;
import org.apache.karaf.jndi.command.JndiCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="jndi", name="names", description="List the JNDI names.")
public class NamesCommand
extends JndiCommandSupport {
    @Argument(index=0, name="context", description="The JNDI context to display the names", required=false, multiValued=false)
    String context;

    @Override
    public Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("JNDI Name");
        table.column("Class Name");
        Map names = this.context == null ? this.getJndiService().names() : this.getJndiService().names(this.context);
        for (String name : names.keySet()) {
            table.addRow().addContent(new Object[]{name, names.get(name)});
        }
        table.print(System.out);
        return null;
    }
}

