/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import java.util.List;
import org.apache.karaf.jndi.command.JndiCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="jndi", name="contexts", description="List the JNDI sub-contexts.")
public class ContextsCommand
extends JndiCommandSupport {
    @Argument(index=0, name="context", description="The base JNDI context", required=false, multiValued=false)
    String context;

    @Override
    public Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("JNDI Sub-Context");
        List contexts = this.context == null ? this.getJndiService().contexts() : this.getJndiService().contexts(this.context);
        for (String c : contexts) {
            table.addRow().addContent(new Object[]{c});
        }
        table.print(System.out);
        return null;
    }
}

