/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.spring_security_crypto.impl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.jaas.modules.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public class SpringSecurityCryptoEncryption
implements Encryption {
    private static final Logger log = LoggerFactory.getLogger(SpringSecurityCryptoEncryption.class);
    private static final Map<String, Class<? extends PasswordEncoder>> PASSWORD_ENCODERS;
    private PasswordEncoder passwordEncoder;
    private String encoding;

    public SpringSecurityCryptoEncryption(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if ("algorithm".equalsIgnoreCase(entry.getKey())) {
                if (!PASSWORD_ENCODERS.containsKey(entry.getValue())) {
                    throw new IllegalArgumentException("Unsupported algorithm parameter: " + entry.getValue());
                }
                try {
                    this.passwordEncoder = PASSWORD_ENCODERS.get(entry.getValue()).newInstance();
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Unsupported encryption parameter: " + entry.getKey());
                }
            }
            if (!"encoding".equalsIgnoreCase(entry.getKey())) continue;
            this.encoding = entry.getValue();
        }
        if (this.passwordEncoder == null) {
            throw new IllegalArgumentException("Digest algorithm must be specified");
        }
        if (this.encoding != null && this.encoding.length() > 0 && !"hexadecimal".equalsIgnoreCase(this.encoding) && !"base64".equalsIgnoreCase(this.encoding)) {
            log.error("Initialization failed. Digest encoding " + this.encoding + " is not supported.");
            throw new IllegalArgumentException("Unable to configure login module. Digest Encoding " + this.encoding + " not supported.");
        }
    }

    public String encryptPassword(String plain) {
        String encryptedPassword = this.passwordEncoder.encode((CharSequence)plain);
        if ("hexadecimal".equalsIgnoreCase(this.encoding)) {
            return new String(Hex.encode((byte[])encryptedPassword.getBytes(StandardCharsets.UTF_8)));
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            return Base64.getEncoder().encodeToString(encryptedPassword.getBytes(StandardCharsets.UTF_8));
        }
        return encryptedPassword;
    }

    public boolean checkPassword(String password, String input) {
        String decodedInput = input;
        if ("hexadecimal".equalsIgnoreCase(this.encoding)) {
            decodedInput = new String(Hex.decode((CharSequence)input));
        } else if ("base64".equalsIgnoreCase(this.encoding)) {
            decodedInput = new String(Base64.getDecoder().decode(input), StandardCharsets.UTF_8);
        }
        return this.passwordEncoder.matches((CharSequence)password, decodedInput);
    }

    static {
        HashMap<String, Class> passwordEncoders = new HashMap<String, Class>();
        passwordEncoders.put("pbkdf2", Pbkdf2PasswordEncoder.class);
        passwordEncoders.put("bcrypt", BCryptPasswordEncoder.class);
        passwordEncoders.put("scrypt", SCryptPasswordEncoder.class);
        passwordEncoders.put("argon2", Argon2PasswordEncoder.class);
        PASSWORD_ENCODERS = Collections.unmodifiableMap(passwordEncoders);
    }
}

