/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.ldap.LDAPLoginModule;
import org.apache.karaf.jaas.modules.ldap.ManagedSSLSocketFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPOptions {
    public static final String CONNECTION_URL = "connection.url";
    public static final String CONNECTION_USERNAME = "connection.username";
    public static final String CONNECTION_PASSWORD = "connection.password";
    public static final String USER_BASE_DN = "user.base.dn";
    public static final String USER_FILTER = "user.filter";
    public static final String USER_SEARCH_SUBTREE = "user.search.subtree";
    public static final String USER_PUBKEY_ATTRIBUTE = "user.pubkey.attribute";
    public static final String ROLE_BASE_DN = "role.base.dn";
    public static final String ROLE_FILTER = "role.filter";
    public static final String ROLE_NAME_ATTRIBUTE = "role.name.attribute";
    public static final String ROLE_SEARCH_SUBTREE = "role.search.subtree";
    public static final String ROLE_MAPPING = "role.mapping";
    public static final String AUTHENTICATION = "authentication";
    public static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    public static final String DISABLE_CACHE = "disableCache";
    public static final String INITIAL_CONTEXT_FACTORY = "initial.context.factory";
    public static final String CONTEXT_PREFIX = "context.";
    public static final String SSL = "ssl";
    public static final String SSL_PROVIDER = "ssl.provider";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    public static final String SSL_ALGORITHM = "ssl.algorithm";
    public static final String SSL_KEYSTORE = "ssl.keystore";
    public static final String SSL_KEYALIAS = "ssl.keyalias";
    public static final String SSL_TRUSTSTORE = "ssl.truststore";
    public static final String SSL_TIMEOUT = "ssl.timeout";
    public static final String USERNAMES_TRIM = "usernames.trim";
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String DEFAULT_AUTHENTICATION = "simple";
    public static final String IGNORE_PARTIAL_RESULT_EXCEPTION = "ignorePartialResultException";
    public static final int DEFAULT_SSL_TIMEOUT = 10;
    private static Logger LOGGER = LoggerFactory.getLogger(LDAPLoginModule.class);
    private final Map<String, ?> options;

    public LDAPOptions(Map<String, ?> options) {
        this.options = new HashMap(options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDAPOptions that = (LDAPOptions)o;
        return this.options.equals(that.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public boolean isUsernameTrim() {
        return Boolean.parseBoolean(JAASUtils.getString(this.options, USERNAMES_TRIM));
    }

    public String getUserFilter() {
        return JAASUtils.getString(this.options, USER_FILTER);
    }

    public String getUserBaseDn() {
        return JAASUtils.getString(this.options, USER_BASE_DN);
    }

    public boolean getUserSearchSubtree() {
        return Boolean.parseBoolean(JAASUtils.getString(this.options, USER_SEARCH_SUBTREE));
    }

    public String getUserPubkeyAttribute() {
        return JAASUtils.getString(this.options, USER_PUBKEY_ATTRIBUTE);
    }

    public String getRoleFilter() {
        return JAASUtils.getString(this.options, ROLE_FILTER);
    }

    public String getRoleBaseDn() {
        return JAASUtils.getString(this.options, ROLE_BASE_DN);
    }

    public boolean getRoleSearchSubtree() {
        return Boolean.parseBoolean(JAASUtils.getString(this.options, ROLE_SEARCH_SUBTREE));
    }

    public String getRoleNameAttribute() {
        return JAASUtils.getString(this.options, ROLE_NAME_ATTRIBUTE);
    }

    public Map<String, Set<String>> getRoleMapping() {
        return this.parseRoleMapping(JAASUtils.getString(this.options, ROLE_MAPPING));
    }

    private Map<String, Set<String>> parseRoleMapping(String option) {
        HashMap<String, Set<String>> roleMapping = new HashMap<String, Set<String>>();
        if (option != null) {
            String[] mappings;
            LOGGER.debug("Parse role mapping {}", (Object)option);
            for (String mapping : mappings = option.split(";")) {
                int index = mapping.lastIndexOf("=");
                String ldapRole = mapping.substring(0, index).trim();
                String[] karafRoles = mapping.substring(index + 1).split(",");
                Set karafRolesSet = roleMapping.computeIfAbsent(ldapRole, k -> new HashSet());
                for (String karafRole : karafRoles) {
                    karafRolesSet.add(karafRole.trim());
                }
            }
        }
        return roleMapping;
    }

    public Hashtable<String, Object> getEnv() throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        for (String key : this.options.keySet()) {
            if (!key.startsWith(CONTEXT_PREFIX)) continue;
            env.put(key.substring(CONTEXT_PREFIX.length()), this.options.get(key));
        }
        env.put("java.naming.factory.initial", this.getInitialContextFactory());
        env.put("java.naming.provider.url", this.getConnectionURL());
        if (this.getConnectionUsername() != null && this.getConnectionUsername().trim().length() > 0) {
            String auth = this.getAuthentication();
            if (auth == null) {
                auth = DEFAULT_AUTHENTICATION;
            }
            env.put("java.naming.security.authentication", auth);
            env.put("java.naming.security.principal", this.getConnectionUsername());
            env.put("java.naming.security.credentials", this.getConnectionPassword());
        } else if (this.getAuthentication() != null) {
            env.put("java.naming.security.authentication", this.getAuthentication());
        }
        if (this.getSsl()) {
            this.setupSsl(env);
        }
        return env;
    }

    protected void setupSsl(Hashtable<String, Object> env) throws NamingException {
        BundleContext bundleContext = FrameworkUtil.getBundle(LDAPOptions.class).getBundleContext();
        ServiceReference ref = null;
        try {
            LOGGER.debug("Setting up SSL");
            env.put("java.naming.security.protocol", SSL);
            env.put("java.naming.ldap.factory.socket", ManagedSSLSocketFactory.class.getName());
            ref = bundleContext.getServiceReference(KeystoreManager.class);
            KeystoreManager manager = (KeystoreManager)bundleContext.getService(ref);
            SSLSocketFactory factory = manager.createSSLFactory(this.getSslProvider(), this.getSslProtocol(), this.getSslAlgorithm(), this.getSslKeystore(), this.getSslKeyAlias(), this.getSslTrustStore(), (long)this.getSslTimeout());
            ManagedSSLSocketFactory.setSocketFactory(new ManagedSSLSocketFactory(factory));
            Thread.currentThread().setContextClassLoader(ManagedSSLSocketFactory.class.getClassLoader());
        }
        catch (Exception e) {
            try {
                throw new NamingException("Unable to setup SSL support for LDAP: " + e.getMessage());
            }
            catch (Throwable throwable) {
                bundleContext.ungetService(ref);
                throw throwable;
            }
        }
        bundleContext.ungetService(ref);
    }

    public Object getInitialContextFactory() {
        String initialContextFactory = JAASUtils.getString(this.options, INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory == null) {
            initialContextFactory = DEFAULT_INITIAL_CONTEXT_FACTORY;
        }
        return initialContextFactory;
    }

    public String getConnectionURL() {
        String connectionURL = JAASUtils.getString(this.options, CONNECTION_URL);
        if (connectionURL == null || connectionURL.trim().length() == 0) {
            LOGGER.error("No LDAP URL specified.");
        } else if (!connectionURL.startsWith("ldap:") && !connectionURL.startsWith("ldaps:")) {
            LOGGER.error("Invalid LDAP URL: " + connectionURL);
        }
        return connectionURL;
    }

    public String getConnectionUsername() {
        return JAASUtils.getString(this.options, CONNECTION_USERNAME);
    }

    public String getConnectionPassword() {
        return JAASUtils.getString(this.options, CONNECTION_PASSWORD);
    }

    public String getAuthentication() {
        return JAASUtils.getString(this.options, AUTHENTICATION);
    }

    public boolean getSsl() {
        Object val = this.options.get(SSL);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val != null) {
            return Boolean.parseBoolean(val.toString());
        }
        return this.getConnectionURL().startsWith("ldaps:");
    }

    public String getSslProvider() {
        return JAASUtils.getString(this.options, SSL_PROVIDER);
    }

    public String getSslProtocol() {
        return JAASUtils.getString(this.options, SSL_PROTOCOL);
    }

    public String getSslAlgorithm() {
        return JAASUtils.getString(this.options, SSL_ALGORITHM);
    }

    public String getSslKeystore() {
        return JAASUtils.getString(this.options, SSL_KEYSTORE);
    }

    public String getSslKeyAlias() {
        return JAASUtils.getString(this.options, SSL_KEYALIAS);
    }

    public String getSslTrustStore() {
        return JAASUtils.getString(this.options, SSL_TRUSTSTORE);
    }

    public int getSslTimeout() {
        Object val = this.options.get(SSL_TIMEOUT);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val != null) {
            return Integer.parseInt(val.toString());
        }
        return 10;
    }

    public boolean getAllowEmptyPasswords() {
        return Boolean.parseBoolean(JAASUtils.getString(this.options, ALLOW_EMPTY_PASSWORDS));
    }

    public boolean getDisableCache() {
        Object object = this.options.get(DISABLE_CACHE);
        return object == null || Boolean.parseBoolean((String)object);
    }

    public boolean getIgnorePartialResultException() {
        return Boolean.parseBoolean((String)this.options.get(IGNORE_PARTIAL_RESULT_EXCEPTION));
    }
}

