/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    private StreamUtils() {
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void close(Iterable<Closeable> closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[16384];
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }
}

