/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.publickey;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.publickey.PublickeyBackingEngine;
import org.apache.karaf.jaas.modules.publickey.PublickeyLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublickeyBackingEngineFactory
implements BackingEngineFactory {
    private final Logger logger = LoggerFactory.getLogger(PublickeyBackingEngineFactory.class);
    private static final String USER_FILE = "users";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingEngine build(Map options) {
        PublickeyBackingEngine engine = null;
        String usersFile = (String)options.get(USER_FILE);
        File f = new File(usersFile);
        try {
            Properties users = new Properties(f);
            engine = new PublickeyBackingEngine(users);
            return engine;
        }
        catch (IOException ioe) {
            this.logger.warn("Cannot open keys file:" + usersFile);
        }
        finally {
            return engine;
        }
    }

    public String getModuleClass() {
        return PublickeyLoginModule.class.getName();
    }
}

