/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.rest.client.jersey;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.apache.karaf.examples.rest.api.Booking;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="booking", name="list", description="List booking")
public class ListBookingCommand
implements Action {
    @Option(name="--url", description="Location of the REST service", required=false, multiValued=false)
    String restLocation = "http://localhost:8181/cxf/booking/";

    public Object execute() throws Exception {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JacksonJsonProvider());
        WebTarget target = client.target(this.restLocation);
        List bookings = (List)target.request(new String[]{"application/json"}).get((GenericType)new GenericType<List<Booking>>(){});
        for (Booking booking : bookings) {
            System.out.println(booking.getId() + " " + booking.getCustomer() + " " + booking.getFlight());
        }
        return null;
    }
}

