/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jms.command;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="example", name="send", description="Send a message to a JMS queue")
public class SendCommand
implements Action {
    @Argument(index=0, name="queue", description="Name of the queue", required=true, multiValued=false)
    String queue;
    @Argument(index=1, name="message", description="Message payload to send", required=true, multiValued=false)
    String message;
    @Reference
    ConnectionFactory connectionFactory;

    public Object execute() throws Exception {
        Connection connection = this.connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.queue);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage textMessage = session.createTextMessage(this.message);
        producer.send((Message)textMessage);
        return null;
    }
}

