/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.graphql.commands;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import org.apache.karaf.examples.graphql.api.GraphQLSchemaProvider;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="graphql", name="query", description="Execute GraphQL query")
public class Query
implements Action {
    @Argument(index=0, name="query", required=true, multiValued=false)
    String query;
    @Reference
    private GraphQLSchemaProvider schemaProvider;

    public Object execute() throws Exception {
        GraphQLSchema schema = this.schemaProvider.createSchema();
        ExecutionResult result = GraphQL.newGraphQL((GraphQLSchema)schema).build().execute(this.query);
        if (result.getData() != null) {
            System.out.println(result.getData().toString());
        } else {
            result.getErrors().forEach(System.out::println);
        }
        return null;
    }
}

