/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.camel.java;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.osgi.OsgiClassResolver;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.LanguageResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="karaf-camel-example-java", immediate=true)
public class CamelComponent {
    private ModelCamelContext camelContext;
    private ServiceRegistration<CamelContext> serviceRegistration;

    @Activate
    public void activate(ComponentContext componentContext) throws Exception {
        BundleContext bundleContext = componentContext.getBundleContext();
        OsgiDefaultCamelContext osgiDefaultCamelContext = new OsgiDefaultCamelContext(bundleContext);
        osgiDefaultCamelContext.setClassResolver((ClassResolver)new OsgiClassResolver((CamelContext)this.camelContext, bundleContext));
        osgiDefaultCamelContext.setDataFormatResolver((DataFormatResolver)new OsgiDataFormatResolver(bundleContext));
        osgiDefaultCamelContext.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver(bundleContext));
        osgiDefaultCamelContext.setName("context-example");
        this.camelContext = osgiDefaultCamelContext;
        this.serviceRegistration = bundleContext.registerService(CamelContext.class, (Object)this.camelContext, null);
        this.camelContext.start();
        this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("jetty:http://0.0.0.0:9090/example").id("example-http-inbound")).convertBodyTo(String.class)).log("[EXAMPLE INBOUND] Received: ${body}")).choice().when().simple("${headers.CamelHttpMethod} == 'POST'")).setHeader("type").jsonpath("$.notification.type")).choice().when().simple("${header.type} == 'email'")).log("[EXAMPLE INBOUND] Received email notification")).to("direct:email")).setHeader("Exchange.HTTP_RESPONSE_CODE", (Expression)this.constant(200))).when().simple("${header.type} == 'http'")).log("[EXAMPLE INBOUND] Received http notification")).to("direct:http")).setHeader("Exchange.HTTP_RESPONSE_CODE", (Expression)this.constant(200))).otherwise().log("[EXAMPLE INBOUND] Unknown notification")).setBody((Expression)this.constant("{ \"status\": \"reject\", \"type\": \"unknown\" }"))).setHeader("Exchange.HTTP_RESPONSE_CODE", (Expression)this.constant(400))).otherwise().log("[EXAMPLE INBOUND] only POST is accepted (${headers.CamelHttpMethod})")).setBody((Expression)this.constant("{ \"error\": \"only POST is accepted\" }"))).setHeader("Exchange.HTTP_RESPONSE_CODE", (Expression)this.constant(500));
                ((ProcessorDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:email").id("example-email")).log("[EXAMPLE EMAIL] Sending notification email")).setHeader("to").jsonpath("$.notification.to")).setHeader("subject", (Expression)this.constant("Notification"))).setHeader("payload").jsonpath("$.notification.message")).setBody((Expression)this.simple("{ \"status\": \"email sent\", \"to\": \"${header.to}\", \"subject\": \"${header.subject}\" }"));
                ((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:http").id("example-http")).log("[EXAMPLE HTTP] Sending http notification")).setHeader("service").jsonpath("$.notification.service")).setBody((Expression)this.simple("{ \"status\": \"http requested\", \"service\": \"${header.service}\" }"));
            }
        });
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.camelContext.stop();
        this.camelContext.removeRouteDefinitions(new ArrayList(this.camelContext.getRouteDefinitions()));
        this.serviceRegistration.unregister();
    }
}

