/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class KafkaClusterThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final Set<Long> threadIds = ConcurrentHashMap.newKeySet();
    private final AtomicLong threadEpoch = new AtomicLong(0L);

    KafkaClusterThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = this.prefix + this.threadEpoch.addAndGet(1L);
        Thread thread = new Thread(r, threadName);
        this.threadIds.add(thread.getId());
        return thread;
    }

    public Set<Long> getThreadIds() {
        return this.threadIds;
    }
}

