/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.TimestampedSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TimestampedSegmentTest {
    private final RocksDBMetricsRecorder metricsRecorder = new RocksDBMetricsRecorder("metrics-scope", "store-name");

    @Before
    public void setUp() {
        this.metricsRecorder.init(new StreamsMetricsImpl(new Metrics(), "test-client", "latest", (Time)new MockTime()), new TaskId(0, 0));
    }

    @Test
    public void shouldDeleteStateDirectoryOnDestroy() throws Exception {
        TimestampedSegment segment = new TimestampedSegment("segment", "window", 0L, this.metricsRecorder);
        String directoryPath = TestUtils.tempDirectory().getAbsolutePath();
        File directory = new File(directoryPath);
        ProcessorContext mockContext = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        Mockito.when((Object)mockContext.appConfigs()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"metrics.recording.level", (Object)"INFO")}));
        Mockito.when((Object)mockContext.stateDir()).thenReturn((Object)directory);
        segment.openDB(mockContext.appConfigs(), mockContext.stateDir());
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
        Assert.assertTrue((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((new File(directoryPath + File.separator + "window", "segment").list().length > 0 ? 1 : 0) != 0);
        segment.destroy();
        Assert.assertFalse((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
        segment.close();
    }

    @Test
    public void shouldBeEqualIfIdIsEqual() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segment));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segmentSameId));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)segmentDifferentId)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"anyName")));
        segment.close();
        segmentSameId.close();
        segmentDifferentId.close();
    }

    @Test
    public void shouldHashOnSegmentIdOnly() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, this.metricsRecorder);
        HashSet<TimestampedSegment> set = new HashSet<TimestampedSegment>();
        Assert.assertTrue((boolean)set.add(segment));
        Assert.assertFalse((boolean)set.add(segmentSameId));
        Assert.assertTrue((boolean)set.add(segmentDifferentId));
        segment.close();
        segmentSameId.close();
        segmentDifferentId.close();
    }

    @Test
    public void shouldCompareSegmentIdOnly() {
        TimestampedSegment segment1 = new TimestampedSegment("a", "C", 50L, this.metricsRecorder);
        TimestampedSegment segment2 = new TimestampedSegment("b", "B", 100L, this.metricsRecorder);
        TimestampedSegment segment3 = new TimestampedSegment("c", "A", 0L, this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment1.compareTo(segment1), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment1), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        segment1.close();
        segment2.close();
        segment3.close();
    }
}

